/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.smallrye.reactive.messaging.extension.AbstractEmitter;
import io.smallrye.reactive.messaging.extension.EmitterConfiguration;
import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class EmitterImpl<T>
extends AbstractEmitter<T>
implements Emitter<T> {
    public EmitterImpl(EmitterConfiguration config, long defaultBufferSize) {
        super(config, defaultBufferSize);
    }

    public synchronized CompletionStage<Void> send(T payload) {
        if (payload == null) {
            throw ProviderExceptions.ex.illegalArgumentForNullValue();
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.emit(Message.of(payload, (Metadata)Metadata.empty(), () -> {
            future.complete(null);
            return CompletableFuture.completedFuture(null);
        }, reason -> {
            future.completeExceptionally((Throwable)reason);
            return CompletableFuture.completedFuture(null);
        }));
        return future;
    }

    public synchronized <M extends Message<? extends T>> void send(M msg) {
        if (msg == null) {
            throw ProviderExceptions.ex.illegalArgumentForNullValue();
        }
        this.emit(msg);
    }
}

