/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.ModuleAvailabilityListener;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.wildfly.httpclient.common.NoFlushByteOutput;
import org.wildfly.httpclient.ejb.EjbHeaders;
import org.wildfly.httpclient.ejb.HttpProtocolV1ObjectTable;
import org.wildfly.httpclient.ejb.RemoteHTTPHandler;

public class HttpDiscoveryHandler
extends RemoteHTTPHandler {
    private final Set<EJBModuleIdentifier> availableModules = new HashSet<EJBModuleIdentifier>();

    public HttpDiscoveryHandler(ExecutorService executorService, Association association) {
        super(executorService);
        association.registerModuleAvailabilityListener(new ModuleAvailabilityListener(){

            @Override
            public void moduleAvailable(List<EJBModuleIdentifier> modules) {
                HttpDiscoveryHandler.this.availableModules.addAll(modules);
            }

            @Override
            public void moduleUnavailable(List<EJBModuleIdentifier> modules) {
                HttpDiscoveryHandler.this.availableModules.removeAll(modules);
            }
        });
    }

    @Override
    protected void handleInternal(HttpServerExchange exchange) throws Exception {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, EjbHeaders.EJB_DISCOVERY_RESPONSE_VERSION_ONE.toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Marshaller marshaller = new RiverMarshallerFactory().createMarshaller(this.createMarshallingConfig());
        marshaller.start(new NoFlushByteOutput(Marshalling.createByteOutput(out)));
        marshaller.writeInt(this.availableModules.size());
        for (EJBModuleIdentifier ejbModuleIdentifier : this.availableModules) {
            marshaller.writeObject(ejbModuleIdentifier);
        }
        marshaller.finish();
        marshaller.flush();
        exchange.getResponseSender().send(ByteBuffer.wrap(out.toByteArray()));
    }

    private MarshallingConfiguration createMarshallingConfig() {
        MarshallingConfiguration marshallingConfiguration = new MarshallingConfiguration();
        marshallingConfiguration.setObjectTable(HttpProtocolV1ObjectTable.INSTANCE);
        marshallingConfiguration.setVersion(2);
        return marshallingConfiguration;
    }
}

