/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.controller.AttributeTranslation;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ReadAttributeTranslationHandler;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleAliasEntry;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.controller.transform.RequiredChildResourceDiscardPolicy;
import org.jboss.as.clustering.controller.validation.EnumValidator;
import org.jboss.as.clustering.infinispan.subsystem.CacheRuntimeResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ComponentResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.LockingMetric;
import org.jboss.as.clustering.infinispan.subsystem.LockingRuntimeResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.LockingServiceConfigurator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.DynamicDiscardPolicy;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class LockingResourceDefinition
extends ComponentResourceDefinition {
    static final PathElement PATH = LockingResourceDefinition.pathElement("locking");
    static final PathElement LEGACY_PATH = PathElement.pathElement((String)PATH.getValue(), (String)"LOCKING");

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder;
        ResourceTransformationDescriptionBuilder resourceTransformationDescriptionBuilder = builder = InfinispanModel.VERSION_4_0_0.requiresTransformation(version) ? parent.addChildRedirection(PATH, LEGACY_PATH, (DynamicDiscardPolicy)RequiredChildResourceDiscardPolicy.NEVER) : parent.addChildResource(PATH);
        if (InfinispanModel.VERSION_3_0_0.requiresTransformation(version)) {
            builder.getAttributeBuilder().setValueConverter(AttributeConverter.DEFAULT_VALUE, new String[]{Attribute.ISOLATION.getName()});
        }
    }

    LockingResourceDefinition() {
        super(PATH);
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        parent.registerAlias(LEGACY_PATH, (AliasEntry)new SimpleAliasEntry((org.jboss.as.controller.registry.ManagementResourceRegistration)registration));
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class);
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler(LockingServiceConfigurator::new);
        new SimpleResourceRegistration(descriptor, (ResourceServiceHandler)handler).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        if (registration.isRuntimeOnlyRegistrationValid()) {
            for (DeprecatedMetric metric : EnumSet.allOf(DeprecatedMetric.class)) {
                metric.register(registration);
            }
        }
        return registration;
    }

    static enum DeprecatedMetric implements AttributeTranslation,
    UnaryOperator<PathAddress>,
    Registration<ManagementResourceRegistration>
    {
        CURRENT_CONCURRENCY_LEVEL(LockingMetric.CURRENT_CONCURRENCY_LEVEL),
        NUMBER_OF_LOCKS_AVAILABLE(LockingMetric.NUMBER_OF_LOCKS_AVAILABLE),
        NUMBER_OF_LOCKS_HELD(LockingMetric.NUMBER_OF_LOCKS_HELD);

        private final AttributeDefinition definition;
        private final org.jboss.as.clustering.controller.Attribute targetAttribute;

        private DeprecatedMetric(LockingMetric metric) {
            this.targetAttribute = metric;
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(metric.getName(), metric.getDefinition().getType()).setDeprecated(InfinispanModel.VERSION_11_0_0.getVersion())).setStorageRuntime()).build();
        }

        public void register(ManagementResourceRegistration registration) {
            registration.registerReadOnlyAttribute(this.definition, (OperationStepHandler)new ReadAttributeTranslationHandler((AttributeTranslation)this));
        }

        public org.jboss.as.clustering.controller.Attribute getTargetAttribute() {
            return this.targetAttribute;
        }

        public UnaryOperator<PathAddress> getPathAddressTransformation() {
            return this;
        }

        @Override
        public PathAddress apply(PathAddress address) {
            PathAddress cacheAddress = address.getParent();
            return cacheAddress.getParent().append(new PathElement[]{CacheRuntimeResourceDefinition.pathElement(cacheAddress.getLastElement().getValue()), LockingRuntimeResourceDefinition.PATH});
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        ACQUIRE_TIMEOUT("acquire-timeout", ModelType.LONG, new ModelNode(TimeUnit.SECONDS.toMillis(15L))){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setMeasurementUnit(MeasurementUnit.MILLISECONDS);
            }
        }
        ,
        CONCURRENCY("concurrency-level", ModelType.INT, new ModelNode(1000)),
        ISOLATION("isolation", ModelType.STRING, new ModelNode(IsolationLevel.READ_COMMITTED.name())){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new EnumValidator(IsolationLevel.class));
            }
        }
        ,
        STRIPING("striping", ModelType.BOOLEAN, ModelNode.FALSE);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }
}

