/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.definition.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationFactory;
import org.hibernate.search.analyzer.definition.LuceneAnalyzerDefinitionContext;
import org.hibernate.search.analyzer.definition.LuceneAnalyzerDefinitionWithTokenizerContext;
import org.hibernate.search.analyzer.definition.LuceneCharFilterDefinitionContext;
import org.hibernate.search.analyzer.definition.LuceneNormalizerDefinitionContext;
import org.hibernate.search.analyzer.definition.LuceneTokenFilterDefinitionContext;
import org.hibernate.search.analyzer.definition.impl.LuceneAnalysisDefinitionRegistryBuilderImpl;
import org.hibernate.search.analyzer.definition.impl.LuceneAnalysisDefinitionUtils;
import org.hibernate.search.analyzer.definition.impl.LuceneCharFilterDefinitionContextImpl;
import org.hibernate.search.analyzer.definition.impl.LuceneTokenFilterDefinitionContextImpl;
import org.hibernate.search.analyzer.definition.impl.LuceneTokenizerDefinitionContextImpl;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.TokenFilterDef;

public class LuceneAnalyzerDefinitionContextImpl
implements LuceneAnalyzerDefinitionContext,
LuceneAnalyzerDefinitionWithTokenizerContext {
    private final LuceneAnalysisDefinitionRegistryBuilderImpl registry;
    private final String name;
    private final LuceneTokenizerDefinitionContextImpl tokenizer = new LuceneTokenizerDefinitionContextImpl();
    private final List<LuceneCharFilterDefinitionContextImpl> charFilters = new ArrayList<LuceneCharFilterDefinitionContextImpl>();
    private final List<LuceneTokenFilterDefinitionContextImpl> tokenFilters = new ArrayList<LuceneTokenFilterDefinitionContextImpl>();

    public LuceneAnalyzerDefinitionContextImpl(LuceneAnalysisDefinitionRegistryBuilderImpl registry, String name) {
        this.registry = registry;
        this.name = name;
    }

    @Override
    public LuceneAnalyzerDefinitionContext analyzer(String name) {
        return this.registry.analyzer(name);
    }

    @Override
    public LuceneNormalizerDefinitionContext normalizer(String name) {
        return this.registry.normalizer(name);
    }

    @Override
    public LuceneAnalyzerDefinitionWithTokenizerContext tokenizer(Class<? extends TokenizerFactory> factory) {
        this.tokenizer.factory(factory);
        return this;
    }

    @Override
    public LuceneAnalyzerDefinitionWithTokenizerContext param(String name, String value) {
        this.tokenizer.param(name, value);
        return this;
    }

    @Override
    public LuceneCharFilterDefinitionContext charFilter(Class<? extends CharFilterFactory> factory) {
        LuceneCharFilterDefinitionContextImpl filter = new LuceneCharFilterDefinitionContextImpl(this, factory);
        this.charFilters.add(filter);
        return filter;
    }

    @Override
    public LuceneTokenFilterDefinitionContext tokenFilter(Class<? extends TokenFilterFactory> factory) {
        LuceneTokenFilterDefinitionContextImpl filter = new LuceneTokenFilterDefinitionContextImpl(this, factory);
        this.tokenFilters.add(filter);
        return filter;
    }

    public AnalyzerDef build() {
        AnnotationDescriptor descriptor = new AnnotationDescriptor(AnalyzerDef.class);
        descriptor.setValue("name", (Object)this.name);
        descriptor.setValue("tokenizer", (Object)this.tokenizer.build());
        descriptor.setValue("charFilters", LuceneAnalysisDefinitionUtils.buildAll(this.charFilters, CharFilterDef[]::new));
        descriptor.setValue("filters", LuceneAnalysisDefinitionUtils.buildAll(this.tokenFilters, TokenFilterDef[]::new));
        return (AnalyzerDef)AnnotationFactory.create((AnnotationDescriptor)descriptor);
    }
}

