/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util.cdi11;

import com.sun.faces.util.cdi11.CDIUtil;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import jakarta.enterprise.util.AnnotationLiteral;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CDIUtilImpl
implements Serializable,
CDIUtil {
    private static final long serialVersionUID = -8101770583567814803L;

    @Override
    public Bean createHelperBean(BeanManager beanManager, Class beanClass) {
        BeanWrapper result = null;
        AnnotatedType annotatedType = beanManager.createAnnotatedType(beanClass);
        InjectionTargetFactory factory = beanManager.getInjectionTargetFactory(annotatedType);
        result = new BeanWrapper(beanClass);
        InjectionTarget injectionTarget = factory.createInjectionTarget((Bean)result);
        result.setInjectionTarget(injectionTarget);
        return result;
    }

    private static class BeanWrapper
    implements Bean {
        private Class beanClass;
        private InjectionTarget injectionTarget = null;

        public BeanWrapper(Class beanClass) {
            this.beanClass = beanClass;
        }

        private void setInjectionTarget(InjectionTarget injectionTarget) {
            this.injectionTarget = injectionTarget;
        }

        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionTarget.getInjectionPoints();
        }

        public String getName() {
            return null;
        }

        public Set<Annotation> getQualifiers() {
            HashSet<Annotation> qualifiers = new HashSet<Annotation>();
            qualifiers.add((Annotation)((Object)new DefaultAnnotationLiteral()));
            qualifiers.add((Annotation)((Object)new AnyAnnotationLiteral()));
            return qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return Dependent.class;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public Set<Type> getTypes() {
            HashSet<Type> types = new HashSet<Type>();
            types.add(this.beanClass);
            types.add((Type)((Object)Object.class));
            return types;
        }

        public boolean isAlternative() {
            return false;
        }

        public boolean isNullable() {
            return false;
        }

        public Object create(CreationalContext ctx) {
            Object instance = this.injectionTarget.produce(ctx);
            this.injectionTarget.inject(instance, ctx);
            this.injectionTarget.postConstruct(instance);
            return instance;
        }

        public void destroy(Object instance, CreationalContext ctx) {
            this.injectionTarget.preDestroy(instance);
            this.injectionTarget.dispose(instance);
            ctx.release();
        }

        public static class AnyAnnotationLiteral
        extends AnnotationLiteral<Any> {
            private static final long serialVersionUID = -4700109250603725375L;
        }

        public static class DefaultAnnotationLiteral
        extends AnnotationLiteral<Default> {
            private static final long serialVersionUID = -9065007202240742004L;
        }
    }
}

