/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.ee.subsystem.Namespace;
import org.jboss.dmr.ModelNode;

public class BeanValidationProfileParsingCompletionHandler
implements ProfileParsingCompletionHandler {
    private static final String BEAN_VALIDATION_NAMESPACE_PREFIX = "urn:jboss:domain:bean-validation:";
    private static final String BEAN_VALIDATION_SUBSYSTEM = "bean-validation";
    private static final String BEAN_VALIDATION_MODULE = "org.wildfly.extension.bean-validation";

    public void handleProfileParsingCompletion(Map<String, List<ModelNode>> profileBootOperations, List<ModelNode> otherBootOperations) {
        Object namespace;
        List<ModelNode> legacyEEOps = null;
        Iterator iterator = EnumSet.allOf(Namespace.class).iterator();
        while (iterator.hasNext() && (!((Namespace)((Object)(namespace = (Namespace)((Object)iterator.next())))).isBeanValidationIncluded() || (legacyEEOps = profileBootOperations.get(((Namespace)((Object)namespace)).getUriString())) == null)) {
        }
        if (legacyEEOps != null) {
            boolean hasBeanValidationOp = false;
            for (String string : profileBootOperations.keySet()) {
                if (!string.startsWith(BEAN_VALIDATION_NAMESPACE_PREFIX)) continue;
                hasBeanValidationOp = true;
                break;
            }
            if (!hasBeanValidationOp) {
                boolean hasBeanValidationExtension = false;
                for (ModelNode op : otherBootOperations) {
                    PathAddress pa = PathAddress.pathAddress((ModelNode)op.get("address"));
                    if (pa.size() != 1 || !"extension".equals(pa.getElement(0).getKey()) || !BEAN_VALIDATION_MODULE.equals(pa.getElement(0).getValue())) continue;
                    hasBeanValidationExtension = true;
                    break;
                }
                if (!hasBeanValidationExtension) {
                    ModelNode modelNode = new ModelNode();
                    modelNode.get("operation").set("add");
                    PathAddress beanValidationExtensionAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"extension", (String)BEAN_VALIDATION_MODULE)});
                    modelNode.get("address").set(beanValidationExtensionAddress.toModelNode());
                    modelNode.get("module").set(BEAN_VALIDATION_MODULE);
                    otherBootOperations.add(modelNode);
                }
                ModelNode modelNode = new ModelNode();
                modelNode.get("operation").set("add");
                PathAddress beanValidationSubsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)BEAN_VALIDATION_SUBSYSTEM)});
                modelNode.get("address").set(beanValidationSubsystemAddress.toModelNode());
                legacyEEOps.add(modelNode);
            }
        }
    }
}

