/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor;

import jakarta.jws.WebMethod;
import jakarta.jws.WebResult;
import jakarta.jws.WebService;
import jakarta.jws.soap.SOAPBinding;
import jakarta.xml.ws.WebServiceProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.WrapperUtil;
import org.apache.cxf.tools.util.AnnotationUtil;

public final class FrontendFactory {
    private Class<?> serviceClass;
    private List<Method> wsMethods;
    private Class<? extends Annotation>[] annotations = new Class[]{SOAPBinding.class, WebService.class, WebServiceProvider.class};

    private FrontendFactory() {
    }

    public static FrontendFactory getInstance() {
        return FrontendFactoryHolder.INSTANCE;
    }

    private boolean isJaxws() {
        if (this.serviceClass == null) {
            return true;
        }
        for (Class<? extends Annotation> annotation : this.annotations) {
            if (!this.serviceClass.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return this.isJAXWSAnnotationExists();
    }

    private boolean isJAXWSAnnotationExists() {
        for (Method method : this.wsMethods) {
            if (WrapperUtil.isWrapperClassExists(method)) {
                return true;
            }
            WebMethod m = (WebMethod)AnnotationUtil.getPrivMethodAnnotation((Method)method, WebMethod.class);
            if (m != null) {
                return true;
            }
            WebResult res = (WebResult)AnnotationUtil.getPrivMethodAnnotation((Method)method, WebResult.class);
            if (res == null) continue;
            return true;
        }
        return false;
    }

    private List<Method> getWSMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : this.serviceClass.getMethods()) {
            if (method.getDeclaringClass().equals(Object.class) || !Modifier.isPublic(method.getModifiers()) || this.isExcluced(method)) continue;
            methods.add(method);
        }
        return methods;
    }

    private boolean isExcluced(Method method) {
        WebMethod webMethod = (WebMethod)AnnotationUtil.getPrivMethodAnnotation((Method)method, WebMethod.class);
        return webMethod != null && webMethod.exclude();
    }

    public Style discoverStyle() {
        if (this.isJaxws()) {
            return Style.Jaxws;
        }
        return Style.Simple;
    }

    public void setServiceClass(Class<?> c) {
        this.serviceClass = c;
        if (c != null) {
            this.wsMethods = this.getWSMethods();
        }
    }

    public static enum Style {
        Jaxws,
        Simple;

    }

    private static final class FrontendFactoryHolder {
        private static final FrontendFactory INSTANCE = new FrontendFactory();

        private FrontendFactoryHolder() {
        }
    }
}

