/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.protocols.Bundler;
import org.jgroups.protocols.TP;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;

public abstract class BaseBundler
implements Bundler {
    protected final Map<Address, List<Message>> msgs = new HashMap<Address, List<Message>>(24);
    protected TP transport;
    protected final ReentrantLock lock = new ReentrantLock();
    protected long count;
    protected ByteArrayDataOutputStream output;
    protected Log log;

    @Override
    public void init(TP transport) {
        this.transport = transport;
        this.log = transport.getLog();
        this.output = new ByteArrayDataOutputStream(transport.getMaxBundleSize() + 3);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void send(Message msg) throws Exception {
    }

    @Override
    public void viewChange(View view) {
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.msgs.values().stream().map(List::size).reduce(0, Integer::sum);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void sendBundledMessages() {
        for (Map.Entry<Address, List<Message>> entry : this.msgs.entrySet()) {
            List<Message> list = entry.getValue();
            if (list.isEmpty()) continue;
            this.output.position(0);
            if (list.size() == 1) {
                this.sendSingleMessage(list.get(0));
                continue;
            }
            Address dst = entry.getKey();
            this.sendMessageList(dst, list.get(0).getSrc(), list);
            if (!this.transport.statsEnabled()) continue;
            this.transport.incrBatchesSent(1);
        }
        this.clearMessages();
        this.count = 0L;
    }

    protected void clearMessages() {
        this.msgs.values().stream().filter(Objects::nonNull).forEach(List::clear);
    }

    protected void sendSingleMessage(Message msg) {
        Address dest = msg.getDest();
        try {
            Util.writeMessage(msg, this.output, dest == null);
            this.transport.doSend(this.output.buffer(), 0, this.output.position(), dest);
            if (this.transport.statsEnabled()) {
                this.transport.incrNumSingleMsgsSent(1);
            }
        }
        catch (Throwable e) {
            this.log.trace(Util.getMessage("SendFailure"), this.transport.localAddress(), dest == null ? "cluster" : dest, msg.size(), e.toString(), msg.printHeaders());
        }
    }

    protected void sendMessageList(Address dest, Address src, List<Message> list) {
        try {
            Util.writeMessageList(dest, src, this.transport.cluster_name.chars(), list, this.output, dest == null, this.transport.getId());
            this.transport.doSend(this.output.buffer(), 0, this.output.position(), dest);
        }
        catch (Throwable e) {
            this.log.trace(Util.getMessage("FailureSendingMsgBundle"), this.transport.localAddress(), e);
        }
    }

    protected void addMessage(Message msg, long size) {
        Address dest = msg.getDest();
        List tmp = this.msgs.computeIfAbsent(dest, k -> new ArrayList(5));
        tmp.add(msg);
        this.count += size;
    }
}

