/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.ce;

import io.smallrye.reactive.messaging.ce.DefaultCloudEventMetadataBuilder;
import io.smallrye.reactive.messaging.ce.OutgoingCloudEventMetadata;
import io.smallrye.reactive.messaging.ce.impl.DefaultOutgoingCloudEventMetadata;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

public final class OutgoingCloudEventMetadataBuilder<T> {
    private final DefaultCloudEventMetadataBuilder<T> builder = new DefaultCloudEventMetadataBuilder();
    private String id;

    public OutgoingCloudEventMetadataBuilder() {
    }

    public OutgoingCloudEventMetadataBuilder(OutgoingCloudEventMetadata<T> existing) {
        this.builder.withSpecVersion(existing.getSpecVersion());
        this.id = existing.getId();
        this.builder.withId(existing.getId());
        this.builder.withSource(existing.getSource());
        this.builder.withType(existing.getType());
        this.builder.withData(existing.getData());
        this.builder.withExtensions(existing.getExtensions());
        this.builder.withTimestamp(existing.getTimeStamp().orElse(null));
        this.builder.withSubject(existing.getSubject().orElse(null));
        this.builder.withDataSchema(existing.getDataSchema().orElse(null));
        this.builder.withDataContentType(existing.getDataContentType().orElse(null));
    }

    public OutgoingCloudEventMetadataBuilder<T> withId(String id) {
        this.id = id;
        this.builder.withId(id);
        return this;
    }

    public OutgoingCloudEventMetadataBuilder<T> withSpecVersion(String specVersion) {
        this.builder.withSpecVersion(specVersion);
        return this;
    }

    public OutgoingCloudEventMetadataBuilder<T> withSource(URI source) {
        this.builder.withSource(source);
        return this;
    }

    public OutgoingCloudEventMetadataBuilder<T> withType(String type) {
        this.builder.withType(type);
        return this;
    }

    public OutgoingCloudEventMetadataBuilder<T> withDataContentType(String dataContentType) {
        this.builder.withDataContentType(dataContentType);
        return this;
    }

    public OutgoingCloudEventMetadataBuilder<T> withDataSchema(URI dataSchema) {
        this.builder.withDataSchema(dataSchema);
        return this;
    }

    public OutgoingCloudEventMetadataBuilder<T> withSubject(String subject) {
        this.builder.withSubject(subject);
        return this;
    }

    public OutgoingCloudEventMetadataBuilder<T> withTimestamp(ZonedDateTime timestamp) {
        this.builder.withTimestamp(timestamp);
        return this;
    }

    public OutgoingCloudEventMetadataBuilder<T> withExtensions(Map<String, Object> extensions) {
        this.builder.withExtensions(extensions);
        return this;
    }

    public OutgoingCloudEventMetadataBuilder<T> withExtension(String name, Object value) {
        this.builder.withExtension(name, value);
        return this;
    }

    public OutgoingCloudEventMetadataBuilder<T> withoutExtension(String name) {
        this.builder.withoutExtension(name);
        return this;
    }

    public OutgoingCloudEventMetadata<T> build() {
        if (this.id == null) {
            this.builder.withId(UUID.randomUUID().toString());
        }
        return new DefaultOutgoingCloudEventMetadata<T>(this.builder.build());
    }
}

