/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.uni.builders.StateHolder;
import io.smallrye.mutiny.operators.uni.builders.UniCreateFromCompletionStage;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;

public class UniCreateFromCompletionStageWithState<T, S>
extends AbstractUni<T> {
    private final Function<S, ? extends CompletionStage<? extends T>> mapper;
    private final StateHolder<S> holder;

    public UniCreateFromCompletionStageWithState(Supplier<S> stateSupplier, Function<S, ? extends CompletionStage<? extends T>> mapper) {
        this.mapper = mapper;
        this.holder = new StateHolder<S>(stateSupplier);
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        CompletionStage<? extends T> stage;
        S state;
        try {
            state = this.holder.get();
        }
        catch (Exception e) {
            subscriber.onSubscribe(EmptyUniSubscription.DONE);
            subscriber.onFailure(e);
            return;
        }
        try {
            stage = this.mapper.apply(state);
            Objects.requireNonNull(stage, "The produced CompletionStage is `null`");
        }
        catch (Throwable err) {
            subscriber.onSubscribe(EmptyUniSubscription.DONE);
            subscriber.onFailure(err);
            return;
        }
        new UniCreateFromCompletionStage.CompletionStageUniSubscription<T>(subscriber, stage).forward();
    }
}

