/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.opentracing.smallrye;

import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedExecutorService;
import io.smallrye.opentracing.SmallRyeClientTracingFeature;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.client.ClientBuilder;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.microprofile.opentracing.ClientTracingRegistrarProvider;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public class WildFlyClientTracingRegistrarProvider
implements ClientTracingRegistrarProvider {
    public ClientBuilder configure(ClientBuilder clientBuilder) {
        ExecutorService executorService;
        try {
            executorService = (ExecutorService)InitialContext.doLookup("java:comp/DefaultManagedExecutorService");
        }
        catch (NamingException e) {
            executorService = Executors.newFixedThreadPool(10);
        }
        return this.configure(clientBuilder, executorService);
    }

    public ClientBuilder configure(ClientBuilder clientBuilder, ExecutorService executorService) {
        Tracer tracer = (Tracer)CDI.current().select(Tracer.class, new Annotation[0]).get();
        ResteasyClientBuilder resteasyClientBuilder = (ResteasyClientBuilder)clientBuilder;
        return (ClientBuilder)resteasyClientBuilder.executorService((ExecutorService)new TracedExecutorService(executorService, tracer)).register((Object)new SmallRyeClientTracingFeature(tracer));
    }
}

