/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.access.InvalidationCacheAccessDelegate;
import org.infinispan.hibernate.cache.commons.access.InvalidationSynchronization;
import org.infinispan.hibernate.cache.commons.access.LocalInvalidationSynchronization;
import org.infinispan.hibernate.cache.commons.access.NonTxPutFromLoadInterceptor;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.access.SessionAccess;
import org.infinispan.interceptors.AsyncInterceptorChain;

public class NonTxInvalidationCacheAccessDelegate
extends InvalidationCacheAccessDelegate {
    private static final SessionAccess SESSION_ACCESS = SessionAccess.findSessionAccess();
    private static final long REMOVE_FLAGS = FlagBitSets.IGNORE_RETURN_VALUES | FlagBitSets.FORCE_WRITE_LOCK;
    protected final AsyncInterceptorChain invoker;
    private final CommandsFactory commandsFactory;
    private final KeyPartitioner keyPartitioner;
    private final InvocationContextFactory contextFactory;
    protected final NonTxPutFromLoadInterceptor nonTxPutFromLoadInterceptor;
    protected final boolean isLocal;

    public NonTxInvalidationCacheAccessDelegate(InfinispanDataRegion region, PutFromLoadValidator validator) {
        super(region, validator);
        this.isLocal = !region.getCache().getCacheConfiguration().clustering().cacheMode().isClustered();
        ComponentRegistry cr = region.getCache().getComponentRegistry();
        this.invoker = (AsyncInterceptorChain)cr.getComponent(AsyncInterceptorChain.class);
        this.commandsFactory = (CommandsFactory)cr.getComponent(CommandsFactory.class);
        this.keyPartitioner = (KeyPartitioner)cr.getComponent(KeyPartitioner.class);
        this.contextFactory = (InvocationContextFactory)cr.getComponent(InvocationContextFactory.class);
        this.nonTxPutFromLoadInterceptor = (NonTxPutFromLoadInterceptor)((Object)cr.getComponent(NonTxPutFromLoadInterceptor.class));
    }

    @Override
    public boolean insert(Object session, Object key, Object value, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        this.write(session, key, value);
        return true;
    }

    @Override
    public boolean update(Object session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.write(session, key, value);
        return true;
    }

    @Override
    public void remove(Object session, Object key) throws CacheException {
        this.write(session, key, null);
    }

    private void write(Object session, Object key, Object value) {
        if (this.isLocal) {
            Object lockOwner = new Object();
            this.registerLocalInvalidation(session, lockOwner, key);
            if (!this.putValidator.beginInvalidatingWithPFER(lockOwner, key, value)) {
                throw log.failedInvalidatePendingPut(key, this.region.getName());
            }
            this.cache.remove(key);
        } else {
            RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, null, this.keyPartitioner.getSegment(key), REMOVE_FLAGS);
            this.registerClusteredInvalidation(session, command.getKeyLockOwner(), command.getKey());
            if (!this.putValidator.beginInvalidatingWithPFER(command.getKeyLockOwner(), key, value)) {
                throw log.failedInvalidatePendingPut(key, this.region.getName());
            }
            InvocationContext ctx = this.contextFactory.createSingleKeyNonTxInvocationContext();
            ctx.setLockOwner(command.getKeyLockOwner());
            this.invoke(session, ctx, command);
        }
    }

    protected void invoke(Object session, InvocationContext ctx, RemoveCommand command) {
        this.invoker.invoke(ctx, (VisitableCommand)command);
    }

    @Override
    public boolean afterInsert(Object session, Object key, Object value, Object version) {
        return false;
    }

    @Override
    public boolean afterUpdate(Object session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        return false;
    }

    @Override
    public void removeAll() throws CacheException {
        try {
            if (!this.putValidator.beginInvalidatingRegion()) {
                log.failedInvalidateRegion(this.region.getName());
            }
            this.cache.clear();
        }
        finally {
            this.putValidator.endInvalidatingRegion();
        }
    }

    protected void registerLocalInvalidation(Object session, Object lockOwner, Object key) {
        SessionAccess.TransactionCoordinatorAccess transactionCoordinator = SESSION_ACCESS.getTransactionCoordinator(session);
        if (transactionCoordinator == null) {
            return;
        }
        if (trace) {
            log.tracef("Registering synchronization on transaction in %s, cache %s: %s", lockOwner, this.cache.getName(), key);
        }
        transactionCoordinator.registerLocalSynchronization(new LocalInvalidationSynchronization(this.putValidator, key, lockOwner));
    }

    protected void registerClusteredInvalidation(Object session, Object lockOwner, Object key) {
        SessionAccess.TransactionCoordinatorAccess transactionCoordinator = SESSION_ACCESS.getTransactionCoordinator(session);
        if (transactionCoordinator == null) {
            return;
        }
        if (trace) {
            log.tracef("Registering synchronization on transaction in %s, cache %s: %s", lockOwner, this.cache.getName(), key);
        }
        transactionCoordinator.registerLocalSynchronization(new InvalidationSynchronization(this.nonTxPutFromLoadInterceptor, key, lockOwner));
    }
}

