/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.Persister;

public interface Message {
    public static final int memoryOffset = 352;
    public static final Predicate<SimpleString> INTERNAL_PROPERTY_NAMES_PREDICATE = name -> name.startsWith(HDR_ROUTE_TO_IDS) && !name.equals((Object)HDR_ROUTE_TO_IDS) || name.startsWith(HDR_ROUTE_TO_ACK_IDS) && !name.equals((Object)HDR_ROUTE_TO_ACK_IDS);
    public static final SimpleString HDR_ROUTE_TO_IDS = new SimpleString("_AMQ_ROUTE_TO");
    public static final SimpleString HDR_SCALEDOWN_TO_IDS = new SimpleString("_AMQ_SCALEDOWN_TO");
    public static final SimpleString HDR_ROUTE_TO_ACK_IDS = new SimpleString("_AMQ_ACK_ROUTE_TO");
    public static final SimpleString HDR_BRIDGE_DUPLICATE_ID = new SimpleString("_AMQ_BRIDGE_DUP");
    public static final SimpleString HDR_ACTUAL_EXPIRY_TIME = new SimpleString("_AMQ_ACTUAL_EXPIRY");
    public static final SimpleString HDR_ORIGINAL_ADDRESS = new SimpleString("_AMQ_ORIG_ADDRESS");
    public static final SimpleString HDR_ORIGINAL_QUEUE = new SimpleString("_AMQ_ORIG_QUEUE");
    public static final SimpleString HDR_ORIG_MESSAGE_ID = new SimpleString("_AMQ_ORIG_MESSAGE_ID");
    public static final SimpleString HDR_GROUP_ID = new SimpleString("_AMQ_GROUP_ID");
    public static final SimpleString HDR_GROUP_SEQUENCE = new SimpleString("_AMQ_GROUP_SEQUENCE");
    public static final SimpleString HDR_LARGE_COMPRESSED = new SimpleString("_AMQ_LARGE_COMPRESSED");
    public static final SimpleString HDR_LARGE_BODY_SIZE = new SimpleString("_AMQ_LARGE_SIZE");
    public static final SimpleString HDR_SCHEDULED_DELIVERY_TIME = new SimpleString("_AMQ_SCHED_DELIVERY");
    public static final SimpleString HDR_DUPLICATE_DETECTION_ID = new SimpleString("_AMQ_DUPL_ID");
    public static final SimpleString HDR_LAST_VALUE_NAME = new SimpleString("_AMQ_LVQ_NAME");
    public static final SimpleString HDR_CONTENT_TYPE = new SimpleString("_AMQ_CONTENT_TYPE");
    public static final SimpleString HDR_VALIDATED_USER = new SimpleString("_AMQ_VALIDATED_USER");
    public static final SimpleString HDR_ROUTING_TYPE = new SimpleString("_AMQ_ROUTING_TYPE");
    public static final SimpleString HDR_PREFIX = new SimpleString("_AMQ_PREFIX");
    public static final byte DEFAULT_TYPE = 0;
    public static final byte OBJECT_TYPE = 2;
    public static final byte TEXT_TYPE = 3;
    public static final byte BYTES_TYPE = 4;
    public static final byte MAP_TYPE = 5;
    public static final byte STREAM_TYPE = 6;
    public static final byte EMBEDDED_TYPE = 7;
    public static final byte LARGE_EMBEDDED_TYPE = 8;

    default public void clearInternalProperties() {
    }

    default public boolean hasScheduledDeliveryTime() {
        return this.getScheduledDeliveryTime() != null;
    }

    default public RoutingType getRoutingType() {
        return null;
    }

    default public Message setRoutingType(RoutingType routingType) {
        return this;
    }

    default public SimpleString getLastValueProperty() {
        return null;
    }

    default public Message setLastValueProperty(SimpleString lastValueName) {
        return this;
    }

    @Deprecated
    default public InputStream getBodyInputStream() {
        return null;
    }

    @Deprecated
    default public ActiveMQBuffer getBodyBuffer() {
        return null;
    }

    @Deprecated
    default public byte getType() {
        return 0;
    }

    @Deprecated
    default public Message setType(byte type) {
        return this;
    }

    public void messageChanged();

    public Long getScheduledDeliveryTime();

    default public Message setScheduledDeliveryTime(Long time) {
        return this;
    }

    default public SimpleString getGroupID() {
        return null;
    }

    default public Message setGroupID(SimpleString groupID) {
        return this;
    }

    default public Message setGroupID(String groupID) {
        return this;
    }

    default public int getGroupSequence() {
        return 0;
    }

    default public Message setGroupSequence(int sequence) {
        return this;
    }

    default public Object getCorrelationID() {
        return null;
    }

    default public Message setCorrelationID(Object correlationID) {
        return this;
    }

    public SimpleString getReplyTo();

    public Message setReplyTo(SimpleString var1);

    public Message setBuffer(ByteBuf var1);

    public ByteBuf getBuffer();

    public Message copy();

    public Message copy(long var1);

    default public Message copy(long newID, boolean isExpiryOrDLQ) {
        return this.copy(newID);
    }

    default public boolean acceptsConsumer(long uniqueConsumerID) {
        return true;
    }

    default public void rejectConsumer(long uniqueConsumerID) {
    }

    public long getMessageID();

    default public Message setConnectionID(String connectionID) {
        return this;
    }

    default public String getConnectionID() {
        return null;
    }

    public Message setMessageID(long var1);

    default public boolean isLargeMessage() {
        return false;
    }

    public long getExpiration();

    public Message setExpiration(long var1);

    default public boolean isExpired() {
        if (this.getExpiration() == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.getExpiration() >= 0L;
    }

    public Object getUserID();

    public Message setUserID(Object var1);

    default public String getValidatedUserID() {
        return null;
    }

    default public Message setValidatedUserID(String validatedUserID) {
        return this;
    }

    public boolean isDurable();

    public Message setDurable(boolean var1);

    public Persister<Message> getPersister();

    public String getAddress();

    public Message setAddress(String var1);

    public SimpleString getAddressSimpleString();

    public Message setAddress(SimpleString var1);

    public long getTimestamp();

    public Message setTimestamp(long var1);

    public byte getPriority();

    public Message setPriority(byte var1);

    public void receiveBuffer(ByteBuf var1);

    public void sendBuffer(ByteBuf var1, int var2);

    public int getPersistSize();

    public void persist(ActiveMQBuffer var1);

    public void reloadPersistence(ActiveMQBuffer var1, CoreMessageObjectPools var2);

    default public void releaseBuffer() {
        ByteBuf buffer = this.getBuffer();
        if (buffer != null) {
            buffer.release();
        }
        this.setBuffer(null);
    }

    default public void reencode() {
    }

    default public void referenceOriginalMessage(Message original, String originalQueue) {
        this.setBrokerProperty(HDR_ORIGINAL_QUEUE, originalQueue);
        this.setBrokerProperty(HDR_ORIGINAL_ADDRESS, original.getAddress());
        this.setBrokerProperty(HDR_ORIG_MESSAGE_ID, original.getMessageID());
        this.setExpiration(0L);
    }

    default public byte[] getDuplicateIDBytes() {
        Object duplicateID = this.getDuplicateProperty();
        if (duplicateID == null) {
            return null;
        }
        if (duplicateID instanceof SimpleString) {
            return ((SimpleString)duplicateID).getData();
        }
        if (duplicateID instanceof String) {
            return new SimpleString(duplicateID.toString()).getData();
        }
        return (byte[])duplicateID;
    }

    default public Message putExtraBytesProperty(SimpleString key, byte[] value) {
        return this.putBytesProperty(key, value);
    }

    default public byte[] getExtraBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getBytesProperty(key);
    }

    default public byte[] removeExtraBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return (byte[])this.removeProperty(key);
    }

    default public Object getDuplicateProperty() {
        return null;
    }

    public Message putBooleanProperty(String var1, boolean var2);

    public Message putByteProperty(String var1, byte var2);

    public Message putBytesProperty(String var1, byte[] var2);

    public Message putShortProperty(String var1, short var2);

    public Message putCharProperty(String var1, char var2);

    public Message putIntProperty(String var1, int var2);

    public Message putLongProperty(String var1, long var2);

    public Message putFloatProperty(String var1, float var2);

    public Message putDoubleProperty(String var1, double var2);

    public Message putBooleanProperty(SimpleString var1, boolean var2);

    public Message putByteProperty(SimpleString var1, byte var2);

    public Message putBytesProperty(SimpleString var1, byte[] var2);

    public Message putShortProperty(SimpleString var1, short var2);

    public Message putCharProperty(SimpleString var1, char var2);

    public Message putIntProperty(SimpleString var1, int var2);

    public Message putLongProperty(SimpleString var1, long var2);

    public Message putFloatProperty(SimpleString var1, float var2);

    public Message putDoubleProperty(SimpleString var1, double var2);

    public Message putStringProperty(String var1, String var2);

    public Message putObjectProperty(String var1, Object var2) throws ActiveMQPropertyConversionException;

    public Message putObjectProperty(SimpleString var1, Object var2) throws ActiveMQPropertyConversionException;

    public Object removeProperty(String var1);

    public boolean containsProperty(String var1);

    public Boolean getBooleanProperty(String var1) throws ActiveMQPropertyConversionException;

    public Byte getByteProperty(String var1) throws ActiveMQPropertyConversionException;

    public Double getDoubleProperty(String var1) throws ActiveMQPropertyConversionException;

    public Integer getIntProperty(String var1) throws ActiveMQPropertyConversionException;

    public Long getLongProperty(String var1) throws ActiveMQPropertyConversionException;

    public Object getObjectProperty(String var1);

    public Short getShortProperty(String var1) throws ActiveMQPropertyConversionException;

    public Float getFloatProperty(String var1) throws ActiveMQPropertyConversionException;

    public String getStringProperty(String var1) throws ActiveMQPropertyConversionException;

    public SimpleString getSimpleStringProperty(String var1) throws ActiveMQPropertyConversionException;

    public byte[] getBytesProperty(String var1) throws ActiveMQPropertyConversionException;

    public Object removeProperty(SimpleString var1);

    public boolean containsProperty(SimpleString var1);

    public Boolean getBooleanProperty(SimpleString var1) throws ActiveMQPropertyConversionException;

    public Byte getByteProperty(SimpleString var1) throws ActiveMQPropertyConversionException;

    public Double getDoubleProperty(SimpleString var1) throws ActiveMQPropertyConversionException;

    public Integer getIntProperty(SimpleString var1) throws ActiveMQPropertyConversionException;

    public Long getLongProperty(SimpleString var1) throws ActiveMQPropertyConversionException;

    default public Object getObjectPropertyForFilter(SimpleString key) {
        return this.getObjectProperty(key);
    }

    public Object getObjectProperty(SimpleString var1);

    default public Object removeAnnotation(SimpleString key) {
        return this.removeProperty(key);
    }

    default public String getAnnotationString(SimpleString key) {
        Object value = this.getAnnotation(key);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public Object getAnnotation(SimpleString var1);

    default public Message setAnnotation(SimpleString key, Object value) {
        this.putObjectProperty(key, value);
        return this;
    }

    default public Message setBrokerProperty(SimpleString key, Object value) {
        this.putObjectProperty(key, value);
        return this;
    }

    default public Object getBrokerProperty(SimpleString key) {
        return this.getObjectProperty(key);
    }

    public Short getShortProperty(SimpleString var1) throws ActiveMQPropertyConversionException;

    public Float getFloatProperty(SimpleString var1) throws ActiveMQPropertyConversionException;

    public String getStringProperty(SimpleString var1) throws ActiveMQPropertyConversionException;

    public SimpleString getSimpleStringProperty(SimpleString var1) throws ActiveMQPropertyConversionException;

    public byte[] getBytesProperty(SimpleString var1) throws ActiveMQPropertyConversionException;

    public Message putStringProperty(SimpleString var1, SimpleString var2);

    public Message putStringProperty(SimpleString var1, String var2);

    public int getEncodeSize();

    default public long getWholeMessageSize() {
        return this.getEncodeSize();
    }

    public Set<SimpleString> getPropertyNames();

    public int getRefCount();

    public int getUsage();

    public int getDurableCount();

    public int usageUp();

    public int usageDown();

    public int refUp();

    public int refDown();

    public int durableUp();

    public int durableDown();

    default public Map<String, Object> toMap() {
        Map<String, Object> map = this.toPropertyMap();
        map.put("messageID", this.getMessageID());
        Object userID = this.getUserID();
        if (this.getUserID() != null) {
            map.put("userID", "ID:" + userID.toString());
        }
        map.put("address", this.getAddress() == null ? "" : this.getAddress());
        map.put("durable", this.isDurable());
        map.put("expiration", this.getExpiration());
        map.put("timestamp", this.getTimestamp());
        map.put("priority", this.getPriority());
        return map;
    }

    default public Map<String, Object> toPropertyMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (SimpleString name : this.getPropertyNames()) {
            Object value = this.getObjectProperty(name.toString());
            if (value instanceof SimpleString) {
                value = value.toString();
            }
            map.put(name.toString(), value);
        }
        return map;
    }

    public ICoreMessage toCore();

    public ICoreMessage toCore(CoreMessageObjectPools var1);

    public int getMemoryEstimate();

    public long getPersistentSize() throws ActiveMQException;
}

