/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import jakarta.jms.JMSException;
import jakarta.jms.XAQueueConnection;
import jakarta.jms.XAQueueSession;
import jakarta.jms.XASession;
import jakarta.jms.XATopicConnection;
import jakarta.jms.XATopicSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.jms.client.HornetQConnection;

public final class HornetQXAConnection
extends HornetQConnection
implements XATopicConnection,
XAQueueConnection {
    public HornetQXAConnection(String username, String password, int connectionType, String clientID, int dupsOKBatchSize, int transactionBatchSize, ClientSessionFactory sessionFactory) {
        super(username, password, connectionType, clientID, dupsOKBatchSize, transactionBatchSize, sessionFactory);
    }

    public XASession createXASession() throws JMSException {
        this.checkClosed();
        return (XASession)this.createSessionInternal(this.isXA(), true, 0, 0);
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        this.checkClosed();
        return (XAQueueSession)this.createSessionInternal(this.isXA(), true, 0, 1);
    }

    public XATopicSession createXATopicSession() throws JMSException {
        this.checkClosed();
        return (XATopicSession)this.createSessionInternal(this.isXA(), true, 0, 2);
    }

    @Override
    protected boolean isXA() {
        return true;
    }
}

