/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.bridge.inbound;

import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.TransactionRequiredException;
import jakarta.transaction.TransactionalException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Provider
public class TransactionalExceptionMapper
implements ExceptionMapper<TransactionalException> {
    public static final String TRANSACTIONA_REQUIRED_MESSAGE = "REST-AT transaction is required for this request.";
    public static final String INVALID_TRANSACTIONA_MESSAGE = "REST-AT transaction is not supported by this resource.";

    public Response toResponse(TransactionalException exception) {
        if (exception.getCause() instanceof InvalidTransactionException) {
            return Response.status((int)412).entity((Object)INVALID_TRANSACTIONA_MESSAGE).build();
        }
        if (exception.getCause() instanceof TransactionRequiredException) {
            return Response.status((int)412).entity((Object)TRANSACTIONA_REQUIRED_MESSAGE).build();
        }
        throw exception;
    }
}

