/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config.smallrye;

import io.smallrye.config.PropertiesConfigSource;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeMarshallers;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.AttributeParsers;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.wildfly.extension.microprofile.config.smallrye.ClassConfigSourceRegistrationService;
import org.wildfly.extension.microprofile.config.smallrye.DirConfigSourceRegistrationService;
import org.wildfly.extension.microprofile.config.smallrye.MicroProfileConfigExtension;
import org.wildfly.extension.microprofile.config.smallrye.PropertiesConfigSourceRegistrationService;
import org.wildfly.extension.microprofile.config.smallrye.Registry;
import org.wildfly.extension.microprofile.config.smallrye._private.MicroProfileConfigLogger;

class ConfigSourceDefinition
extends PersistentResourceDefinition {
    static AttributeDefinition ORDINAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"ordinal", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(100))).setAllowExpression(true)).setRequired(false)).setRestartAllServices()).build();
    static AttributeDefinition PROPERTIES = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("properties", true).setAttributeParser((AttributeParser)new AttributeParsers.PropertiesParser(false))).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.PropertiesAttributeMarshaller(null, false))).setAlternatives(new String[]{"class", "dir"})).setRequired(false)).setRestartAllServices()).build();
    static ObjectTypeAttributeDefinition CLASS = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"class", (AttributeDefinition[])new AttributeDefinition[]{((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(false)).build(), ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(false)).build()}).setAlternatives(new String[]{"properties", "dir"})).setRequired(false)).setAttributeMarshaller(AttributeMarshaller.ATTRIBUTE_OBJECT)).setRestartAllServices()).build();
    static AttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"path", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(true)).addArbitraryDescriptor("filesystem-path", ModelNode.TRUE)).build();
    static AttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"relative-to", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(false)).build();
    static ObjectTypeAttributeDefinition DIR = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"dir", (AttributeDefinition[])new AttributeDefinition[]{PATH, RELATIVE_TO}).setAlternatives(new String[]{"properties", "class"})).setAllowNull(true).setAttributeMarshaller(AttributeMarshaller.ATTRIBUTE_OBJECT)).setRestartAllServices()).setCapabilityReference("org.wildfly.management.path-manager")).build();
    static AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ORDINAL, PROPERTIES, CLASS, DIR};

    protected ConfigSourceDefinition(Registry<ConfigSource> sources) {
        super(new SimpleResourceDefinition.Parameters(MicroProfileConfigExtension.CONFIG_SOURCE_PATH, MicroProfileConfigExtension.getResourceDescriptionResolver(MicroProfileConfigExtension.CONFIG_SOURCE_PATH.getKey())).setAddHandler((OperationStepHandler)new ConfigSourceDefinitionAddHandler(sources)).setRemoveHandler((OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    private static Class unwrapClass(ModelNode classModel) throws OperationFailedException {
        String className = classModel.get("name").asString();
        String moduleName = classModel.get("module").asString();
        try {
            ModuleIdentifier moduleID = ModuleIdentifier.fromString((String)moduleName);
            Module module = Module.getCallerModuleLoader().loadModule(moduleID);
            Class clazz = module.getClassLoader().loadClass(className);
            return clazz;
        }
        catch (Exception e) {
            throw MicroProfileConfigLogger.ROOT_LOGGER.unableToLoadClassFromModule(className, moduleName);
        }
    }

    private static class ConfigSourceDefinitionAddHandler
    extends AbstractAddStepHandler {
        private final Registry<ConfigSource> sources;

        ConfigSourceDefinitionAddHandler(Registry<ConfigSource> sources) {
            super(ATTRIBUTES);
            this.sources = sources;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            String name = context.getCurrentAddressValue();
            int ordinal = ORDINAL.resolveModelAttribute(context, model).asInt();
            ModelNode classModel = CLASS.resolveModelAttribute(context, model);
            ModelNode dirModel = DIR.resolveModelAttribute(context, model);
            if (classModel.isDefined()) {
                try {
                    ClassConfigSourceRegistrationService.install(context, name, (ConfigSource)ConfigSource.class.cast(ConfigSourceDefinition.unwrapClass(classModel).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])), this.sources);
                }
                catch (Exception e) {
                    throw new OperationFailedException((Throwable)e);
                }
            } else if (dirModel.isDefined()) {
                DirConfigSourceRegistrationService.install(context, name, PATH.resolveModelAttribute(context, dirModel).asString(), RELATIVE_TO.resolveModelAttribute(context, dirModel).asStringOrNull(), ordinal, this.sources);
            } else {
                PropertiesConfigSourceRegistrationService.install(context, name, new PropertiesConfigSource(PropertiesAttributeDefinition.unwrapModel((ExpressionResolver)context, (ModelNode)PROPERTIES.resolveModelAttribute(context, model)), name, ordinal), this.sources);
            }
        }
    }
}

