/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.mediatype;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.media.MediaTypeImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.encoding.EncodingReader;
import io.smallrye.openapi.runtime.io.example.ExampleReader;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.io.schema.SchemaReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.jboss.jandex.AnnotationInstance;

public class MediaTypeReader {
    private MediaTypeReader() {
    }

    public static MediaType readMediaType(AnnotationScannerContext context, AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        IoLogging.logger.singleAnnotationAs("@Content", "MediaType");
        MediaTypeImpl mediaType = new MediaTypeImpl();
        mediaType.setExamples(ExampleReader.readExamples(annotationInstance.value("examples")));
        mediaType.setExample(JandexUtil.stringValue(annotationInstance, "example"));
        mediaType.setSchema(SchemaFactory.readSchema(context, annotationInstance.value("schema")));
        mediaType.setEncoding(EncodingReader.readEncodings(context, annotationInstance.value("encoding")));
        return mediaType;
    }

    public static MediaType readMediaType(JsonNode node) {
        if (node == null || !node.isObject()) {
            return null;
        }
        IoLogging.logger.singleJsonNode("Content");
        MediaTypeImpl mediaType = new MediaTypeImpl();
        mediaType.setSchema(SchemaReader.readSchema(node.get("schema")));
        mediaType.setExample(JsonUtil.readObject(node.get("example")));
        mediaType.setExamples(ExampleReader.readExamples(node.get("examples")));
        mediaType.setEncoding(EncodingReader.readEncodings(node.get("encoding")));
        ExtensionReader.readExtensions(node, mediaType);
        return mediaType;
    }
}

