/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationResourceBundle;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.manager.documents.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.el.ChainAwareVariableResolver;
import com.sun.faces.el.DummyPropertyResolverImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.el.ELResolver;
import jakarta.faces.application.Application;
import jakarta.faces.application.ConfigurableNavigationHandler;
import jakarta.faces.application.NavigationHandler;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.application.StateManager;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.search.SearchExpressionHandler;
import jakarta.faces.component.search.SearchKeywordResolver;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.PropertyResolver;
import jakarta.faces.el.VariableResolver;
import jakarta.faces.event.ActionListener;
import jakarta.faces.event.NamedEvent;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import jakarta.servlet.ServletContext;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String APPLICATION = "application";
    private static final String ACTION_LISTENER = "action-listener";
    private static final String DEFAULT_RENDERKIT_ID = "default-render-kit-id";
    private static final String DEFAULT_VALIDATORS = "default-validators";
    private static final String VALIDATOR_ID = "validator-id";
    private static final String MESSAGE_BUNDLE = "message-bundle";
    private static final String NAVIGATION_HANDLER = "navigation-handler";
    private static final String VIEW_HANDLER = "view-handler";
    private static final String STATE_MANAGER = "state-manager";
    private static final String RESOURCE_HANDLER = "resource-handler";
    private static final String EL_RESOLVER = "el-resolver";
    private static final String SEARCH_EXPRESSION_HANDLER = "search-expression-handler";
    private static final String SEARCH_KEYWORD_RESOLVER = "search-keyword-resolver";
    private static final String PROPERTY_RESOLVER = "property-resolver";
    private static final String VARIABLE_RESOLVER = "variable-resolver";
    private static final String DEFAULT_LOCALE = "default-locale";
    private static final String SUPPORTED_LOCALE = "supported-locale";
    private static final String RESOURCE_BUNDLE = "resource-bundle";
    private static final String BASE_NAME = "base-name";
    private static final String VAR = "var";
    private static final String RES_DESCRIPTIONS = "description";
    private static final String RES_DISPLAY_NAMES = "display-name";
    private static final String SYSTEM_EVENT_LISTENER = "system-event-listener";
    private static final String SYSTEM_EVENT_LISTENER_CLASS = "system-event-listener-class";
    private static final String SYSTEM_EVENT_CLASS = "system-event-class";
    private static final String SOURCE_CLASS = "source-class";
    private List<ActionListener> actionListeners = new CopyOnWriteArrayList<ActionListener>();
    private List<NavigationHandler> navigationHandlers = new CopyOnWriteArrayList<NavigationHandler>();
    private List<ViewHandler> viewHandlers = new CopyOnWriteArrayList<ViewHandler>();
    private List<StateManager> stateManagers = new CopyOnWriteArrayList<StateManager>();
    private List<ResourceHandler> resourceHandlers = new CopyOnWriteArrayList<ResourceHandler>();
    private List<ELResolver> elResolvers = new CopyOnWriteArrayList<ELResolver>();
    private List<SystemEventListener> systemEventListeners = new CopyOnWriteArrayList<SystemEventListener>();
    private List<SearchExpressionHandler> searchExpressionHandlers = new CopyOnWriteArrayList<SearchExpressionHandler>();
    private List<SearchKeywordResolver> searchKeywordResolvers = new CopyOnWriteArrayList<SearchKeywordResolver>();

    @Override
    public void process(ServletContext servletContext, FacesContext facesContext, DocumentInfo[] documentInfos) throws Exception {
        Application application = this.getApplication();
        ApplicationAssociate associate = ApplicationAssociate.getInstance(facesContext.getExternalContext());
        LinkedHashMap<String, Node> viewHandlers = new LinkedHashMap<String, Node>();
        LinkedHashSet<String> defaultValidatorIds = null;
        for (int i = 0; i < documentInfos.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing application elements for document: ''{0}''", documentInfos[i].getSourceURI()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList applicationElements = document.getDocumentElement().getElementsByTagNameNS(namespace, APPLICATION);
            if (applicationElements == null || applicationElements.getLength() <= 0) continue;
            int asize = applicationElements.getLength();
            for (int a = 0; a < asize; ++a) {
                Node appElement = applicationElements.item(a);
                NodeList children = ((Element)appElement).getElementsByTagNameNS(namespace, "*");
                if (children == null || children.getLength() <= 0) continue;
                int csize = children.getLength();
                block42: for (int c = 0; c < csize; ++c) {
                    Node n = children.item(c);
                    switch (n.getLocalName()) {
                        case "message-bundle": {
                            this.setMessageBundle(application, n);
                            continue block42;
                        }
                        case "default-render-kit-id": {
                            this.setDefaultRenderKitId(application, n);
                            continue block42;
                        }
                        case "action-listener": {
                            this.addActionListener(servletContext, facesContext, application, n);
                            continue block42;
                        }
                        case "navigation-handler": {
                            this.setNavigationHandler(servletContext, facesContext, application, n);
                            continue block42;
                        }
                        case "view-handler": {
                            String viewHandler = this.getNodeText(n);
                            if (viewHandler == null) continue block42;
                            viewHandlers.put(viewHandler, n);
                            continue block42;
                        }
                        case "state-manager": {
                            this.setStateManager(servletContext, facesContext, application, n);
                            continue block42;
                        }
                        case "el-resolver": {
                            this.addELResolver(servletContext, facesContext, associate, n);
                            continue block42;
                        }
                        case "property-resolver": {
                            this.addPropertyResolver(servletContext, facesContext, associate, n);
                            continue block42;
                        }
                        case "variable-resolver": {
                            this.addVariableResolver(servletContext, facesContext, associate, n);
                            continue block42;
                        }
                        case "default-locale": {
                            this.setDefaultLocale(application, n);
                            continue block42;
                        }
                        case "supported-locale": {
                            this.addSupportedLocale(application, n);
                            continue block42;
                        }
                        case "resource-bundle": {
                            this.addResouceBundle(associate, n);
                            continue block42;
                        }
                        case "resource-handler": {
                            this.setResourceHandler(servletContext, facesContext, application, n);
                            continue block42;
                        }
                        case "system-event-listener": {
                            this.addSystemEventListener(servletContext, facesContext, application, n);
                            continue block42;
                        }
                        case "default-validators": {
                            if (defaultValidatorIds == null) {
                                defaultValidatorIds = new LinkedHashSet<String>();
                                continue block42;
                            }
                            defaultValidatorIds.clear();
                            continue block42;
                        }
                        case "validator-id": {
                            defaultValidatorIds.add(this.getNodeText(n));
                            continue block42;
                        }
                        case "search-expression-handler": {
                            this.setSearchExpressionHandler(servletContext, facesContext, application, n);
                            continue block42;
                        }
                        case "search-keyword-resolver": {
                            this.addSearchKeywordResolver(servletContext, facesContext, application, n);
                        }
                    }
                }
            }
        }
        this.registerDefaultValidatorIds(facesContext, application, defaultValidatorIds);
        this.processViewHandlers(servletContext, facesContext, application, viewHandlers);
        this.processAnnotations(facesContext, NamedEvent.class);
    }

    @Override
    public void destroy(ServletContext sc, FacesContext facesContext) {
        this.destroyInstances(sc, facesContext, this.actionListeners);
        this.destroyInstances(sc, facesContext, this.navigationHandlers);
        this.destroyInstances(sc, facesContext, this.stateManagers);
        this.destroyInstances(sc, facesContext, this.viewHandlers);
        this.destroyInstances(sc, facesContext, this.elResolvers);
        this.destroyInstances(sc, facesContext, this.resourceHandlers);
        this.destroyInstances(sc, facesContext, this.systemEventListeners);
        this.destroyInstances(sc, facesContext, this.searchExpressionHandlers);
        this.destroyInstances(sc, facesContext, this.searchKeywordResolvers);
    }

    private void destroyInstances(ServletContext sc, FacesContext facesContext, List<?> instances) {
        for (Object instance : instances) {
            this.destroyInstance(sc, facesContext, instance.getClass().getName(), instance);
        }
        instances.clear();
    }

    private void registerDefaultValidatorIds(FacesContext facesContext, Application application, LinkedHashSet<String> defaultValidatorIds) {
        if (defaultValidatorIds == null) {
            WebConfiguration webConfig;
            defaultValidatorIds = new LinkedHashSet();
            if (ApplicationConfigProcessor.isBeanValidatorAvailable(facesContext) && !(webConfig = WebConfiguration.getInstance()).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableDefaultBeanValidator)) {
                defaultValidatorIds.add("jakarta.faces.Bean");
            }
        }
        for (String validatorId : defaultValidatorIds) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.addDefaultValidatorId({0})", validatorId));
            }
            application.addDefaultValidatorId(validatorId);
        }
    }

    static boolean isBeanValidatorAvailable(FacesContext facesContext) {
        boolean result = false;
        String beansValidationAvailabilityCacheKey = "jakarta.faces.BEANS_VALIDATION_AVAILABLE";
        Map appMap = facesContext.getExternalContext().getApplicationMap();
        if (appMap.containsKey("jakarta.faces.BEANS_VALIDATION_AVAILABLE")) {
            result = (Boolean)appMap.get("jakarta.faces.BEANS_VALIDATION_AVAILABLE");
        } else {
            block15: {
                try {
                    block17: {
                        InitialContext initialContext;
                        block16: {
                            Thread.currentThread().getContextClassLoader().loadClass("jakarta.validation.MessageInterpolator");
                            Object cachedObject = appMap.get("jakarta.faces.validator.beanValidator.ValidatorFactory");
                            if (cachedObject instanceof ValidatorFactory) {
                                result = true;
                                break block15;
                            }
                            initialContext = null;
                            try {
                                initialContext = new InitialContext();
                            }
                            catch (NoClassDefFoundError nde) {
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.log(Level.FINE, nde.toString(), nde);
                                }
                            }
                            catch (NamingException ne) {
                                if (!LOGGER.isLoggable(Level.WARNING)) break block16;
                                LOGGER.log(Level.WARNING, ne.toString(), ne);
                            }
                        }
                        try {
                            Object validatorFactory = initialContext.lookup("java:comp/ValidatorFactory");
                            if (null != validatorFactory) {
                                appMap.put("jakarta.faces.validator.beanValidator.ValidatorFactory", validatorFactory);
                                result = true;
                            }
                        }
                        catch (NamingException root) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block17;
                            LOGGER.fine("Could not build a default Bean Validator factory: " + root.getMessage());
                        }
                    }
                    if (!result) {
                        try {
                            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                            Validator validator = factory.getValidator();
                            appMap.put("jakarta.faces.validator.beanValidator.ValidatorFactory", factory);
                            result = true;
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable t) {
                    LOGGER.fine("Unable to load Beans Validation");
                }
            }
            appMap.put("jakarta.faces.BEANS_VALIDATION_AVAILABLE", result);
        }
        return result;
    }

    private void setMessageBundle(Application application, Node messageBundle) {
        String bundle;
        if (messageBundle != null && (bundle = this.getNodeText(messageBundle)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setMessageBundle({0})", bundle));
            }
            application.setMessageBundle(bundle);
        }
    }

    private void setDefaultRenderKitId(Application application, Node defaultId) {
        String id;
        if (defaultId != null && (id = this.getNodeText(defaultId)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setDefaultRenderKitId({0})", id));
            }
            application.setDefaultRenderKitId(id);
        }
    }

    private void addActionListener(ServletContext sc, FacesContext facesContext, Application application, Node actionListener) {
        String listener;
        if (actionListener != null && (listener = this.getNodeText(actionListener)) != null) {
            boolean[] didPerformInjection = new boolean[]{false};
            ActionListener instance = (ActionListener)this.createInstance(sc, facesContext, listener, ActionListener.class, application.getActionListener(), actionListener, true, didPerformInjection);
            if (instance != null) {
                if (didPerformInjection[0]) {
                    this.actionListeners.add(instance);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setActionListeners({0})", listener));
                }
                application.setActionListener(instance);
            }
        }
    }

    private void setNavigationHandler(ServletContext sc, FacesContext facesContext, Application application, Node navigationHandler) {
        String handler;
        if (navigationHandler != null && (handler = this.getNodeText(navigationHandler)) != null) {
            Class<?> rootType = this.findRootType(sc, facesContext, handler, navigationHandler, new Class[]{ConfigurableNavigationHandler.class, NavigationHandler.class});
            boolean[] didPerformInjection = new boolean[]{false};
            NavigationHandler instance = (NavigationHandler)this.createInstance(sc, facesContext, handler, rootType != null ? rootType : NavigationHandler.class, application.getNavigationHandler(), navigationHandler, true, didPerformInjection);
            if (instance != null) {
                if (didPerformInjection[0]) {
                    this.navigationHandlers.add(instance);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setNavigationHandlers({0})", handler));
                }
                application.setNavigationHandler(instance);
            }
        }
    }

    private void setStateManager(ServletContext sc, FacesContext facesContext, Application application, Node stateManager) {
        String manager;
        if (stateManager != null && (manager = this.getNodeText(stateManager)) != null) {
            boolean[] didPerformInjection = new boolean[]{false};
            StateManager instance = (StateManager)this.createInstance(sc, facesContext, manager, StateManager.class, application.getStateManager(), stateManager, true, didPerformInjection);
            if (instance != null) {
                if (didPerformInjection[0]) {
                    this.stateManagers.add(instance);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setStateManagers({0})", manager));
                }
                application.setStateManager(instance);
            }
        }
    }

    private void setViewHandler(ServletContext sc, FacesContext facesContext, Application application, Node viewHandler) {
        String handler;
        if (viewHandler != null && (handler = this.getNodeText(viewHandler)) != null) {
            boolean[] didPerformInjection = new boolean[]{false};
            ViewHandler instance = (ViewHandler)this.createInstance(sc, facesContext, handler, ViewHandler.class, application.getViewHandler(), viewHandler, true, didPerformInjection);
            if (instance != null) {
                if (didPerformInjection[0]) {
                    this.viewHandlers.add(instance);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setViewHandler({0})", handler));
                }
                application.setViewHandler(instance);
            }
        }
    }

    private void addELResolver(ServletContext sc, FacesContext facesContext, ApplicationAssociate associate, Node elResolver) {
        if (elResolver != null && associate != null) {
            boolean[] didPerformInjection;
            ELResolver elRes;
            String elResolverClass;
            List<ELResolver> resolvers = associate.getELResolversFromFacesConfig();
            if (resolvers == null) {
                resolvers = new ArrayList<ELResolver>();
                associate.setELResolversFromFacesConfig(resolvers);
            }
            if ((elResolverClass = this.getNodeText(elResolver)) != null && (elRes = (ELResolver)this.createInstance(sc, facesContext, elResolverClass, ELResolver.class, null, elResolver, true, didPerformInjection = new boolean[]{false})) != null) {
                if (didPerformInjection[0]) {
                    this.elResolvers.add(elRes);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to ELResolver chain", elResolverClass));
                }
                resolvers.add(elRes);
            }
        }
    }

    private void setSearchExpressionHandler(ServletContext sc, FacesContext facesContext, Application application, Node searchExpressionHandler) {
        String handler;
        if (searchExpressionHandler != null && (handler = this.getNodeText(searchExpressionHandler)) != null) {
            Class<?> rootType = this.findRootType(sc, facesContext, handler, searchExpressionHandler, new Class[]{SearchExpressionHandler.class});
            boolean[] didPerformInjection = new boolean[]{false};
            SearchExpressionHandler instance = (SearchExpressionHandler)this.createInstance(sc, facesContext, handler, rootType != null ? rootType : SearchExpressionHandler.class, application.getSearchExpressionHandler(), searchExpressionHandler, true, didPerformInjection);
            if (instance != null) {
                if (didPerformInjection[0]) {
                    this.searchExpressionHandlers.add(instance);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setSearchExpressionHandler({0})", handler));
                }
                application.setSearchExpressionHandler(instance);
            }
        }
    }

    private void addSearchKeywordResolver(ServletContext sc, FacesContext facesContext, Application application, Node searchKeywordResolver) {
        boolean[] didPerformInjection;
        SearchKeywordResolver keywordResolver;
        String searchKeywordResolverClass;
        if (searchKeywordResolver != null && (searchKeywordResolverClass = this.getNodeText(searchKeywordResolver)) != null && (keywordResolver = (SearchKeywordResolver)this.createInstance(sc, facesContext, searchKeywordResolverClass, SearchKeywordResolver.class, null, searchKeywordResolver, true, didPerformInjection = new boolean[]{false})) != null) {
            if (didPerformInjection[0]) {
                this.searchKeywordResolvers.add(keywordResolver);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to SearchKeywordResolver chain", searchKeywordResolverClass));
            }
            application.addSearchKeywordResolver(keywordResolver);
        }
    }

    private void addPropertyResolver(ServletContext sc, FacesContext facesContext, ApplicationAssociate associate, Node propertyResolver) {
        if (propertyResolver != null && associate != null) {
            String resolver;
            Object resolverImpl = associate.getLegacyPRChainHead();
            if (resolverImpl == null) {
                resolverImpl = new DummyPropertyResolverImpl();
            }
            if ((resolver = this.getNodeText(propertyResolver)) != null) {
                boolean[] didPerformInjection = new boolean[]{false};
                resolverImpl = this.createInstance(sc, facesContext, resolver, PropertyResolver.class, resolverImpl, propertyResolver, false, didPerformInjection);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to PropertyResolver chain", resolverImpl));
                }
            }
            if (resolverImpl != null) {
                associate.setLegacyPRChainHead((PropertyResolver)resolverImpl);
            }
        }
    }

    private void addVariableResolver(ServletContext sc, FacesContext facesContext, ApplicationAssociate associate, Node variableResolver) {
        if (variableResolver != null && associate != null) {
            String resolver;
            Object resolverImpl = associate.getLegacyVRChainHead();
            if (resolverImpl == null) {
                resolverImpl = new ChainAwareVariableResolver();
            }
            if ((resolver = this.getNodeText(variableResolver)) != null) {
                boolean[] didPerformInjection = new boolean[]{false};
                resolverImpl = this.createInstance(sc, facesContext, resolver, VariableResolver.class, resolverImpl, variableResolver, false, didPerformInjection);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to VariableResolver chain", resolverImpl));
                }
            }
            if (resolverImpl != null) {
                associate.setLegacyVRChainHead((VariableResolver)resolverImpl);
            }
        }
    }

    private void setDefaultLocale(Application application, Node defaultLocale) {
        Locale def;
        String defLocale;
        if (defaultLocale != null && (defLocale = this.getNodeText(defaultLocale)) != null && (def = Util.getLocaleFromString(defLocale)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Setting default Locale to ''{0}''", defLocale));
            }
            application.setDefaultLocale(def);
        }
    }

    private void addSupportedLocale(Application application, Node supportedLocale) {
        if (supportedLocale != null) {
            Set<Locale> sLocales = this.getCurrentLocales(application);
            String locString = this.getNodeText(supportedLocale);
            if (locString != null) {
                Locale loc = Util.getLocaleFromString(locString);
                if (loc != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, MessageFormat.format("Adding supported Locale ''{0}''", locString));
                    }
                    sLocales.add(loc);
                }
                application.setSupportedLocales(sLocales);
            }
        }
    }

    private void addResouceBundle(ApplicationAssociate associate, Node resourceBundle) {
        NodeList children;
        if (resourceBundle != null && (children = resourceBundle.getChildNodes()) != null) {
            String baseName = null;
            String var = null;
            ArrayList<Node> descriptions = null;
            ArrayList<Node> displayNames = null;
            int size = children.getLength();
            block12: for (int i = 0; i < size; ++i) {
                Node n = children.item(i);
                if (n.getNodeType() != 1) continue;
                switch (n.getLocalName()) {
                    case "base-name": {
                        baseName = this.getNodeText(n);
                        continue block12;
                    }
                    case "var": {
                        var = this.getNodeText(n);
                        continue block12;
                    }
                    case "description": {
                        if (descriptions == null) {
                            descriptions = new ArrayList<Node>(2);
                        }
                        descriptions.add(n);
                        continue block12;
                    }
                    case "display-name": {
                        if (displayNames == null) {
                            displayNames = new ArrayList<Node>(2);
                        }
                        displayNames.add(n);
                    }
                }
            }
            if (baseName != null && var != null) {
                associate.addResourceBundle(var, new ApplicationResourceBundle(baseName, this.getTextMap(displayNames), this.getTextMap(descriptions)));
            }
        }
    }

    private Set<Locale> getCurrentLocales(Application application) {
        HashSet<Locale> supportedLocales = new HashSet<Locale>();
        Iterator i = application.getSupportedLocales();
        while (i.hasNext()) {
            supportedLocales.add((Locale)i.next());
        }
        return supportedLocales;
    }

    private void setResourceHandler(ServletContext sc, FacesContext facesContext, Application application, Node resourceHandler) {
        String handler;
        if (resourceHandler != null && (handler = this.getNodeText(resourceHandler)) != null) {
            boolean[] didPerformInjection = new boolean[]{false};
            ResourceHandler instance = (ResourceHandler)this.createInstance(sc, facesContext, handler, ResourceHandler.class, application.getResourceHandler(), resourceHandler, true, didPerformInjection);
            if (instance != null) {
                if (didPerformInjection[0]) {
                    this.resourceHandlers.add(instance);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setResourceHandler({0})", handler));
                }
                application.setResourceHandler(instance);
            }
        }
    }

    private void addSystemEventListener(ServletContext sc, FacesContext facesContext, Application application, Node systemEventListener) {
        SystemEventListener selInstance;
        NodeList children = systemEventListener.getChildNodes();
        String listenerClass = null;
        String eventClass = null;
        String sourceClass = null;
        int len = children.getLength();
        block12: for (int j = 0; j < len; ++j) {
            Node n = children.item(j);
            if (n.getNodeType() != 1) continue;
            switch (n.getLocalName()) {
                case "system-event-listener-class": {
                    listenerClass = this.getNodeText(n);
                    continue block12;
                }
                case "system-event-class": {
                    eventClass = this.getNodeText(n);
                    continue block12;
                }
                case "source-class": {
                    sourceClass = this.getNodeText(n);
                }
            }
        }
        if (listenerClass != null && (selInstance = (SystemEventListener)this.createInstance(sc, facesContext, listenerClass, SystemEventListener.class, null, systemEventListener)) != null) {
            this.systemEventListeners.add(selInstance);
            try {
                Class eventClazz = eventClass != null ? this.loadClass(sc, facesContext, eventClass, this, null) : SystemEvent.class;
                Class sourceClazz = sourceClass != null && sourceClass.length() != 0 ? Util.loadClass(sourceClass, this.getClass()) : null;
                application.subscribeToEvent(eventClazz, sourceClazz, selInstance);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Subscribing for event {0} and source {1} using listener {2}", new Object[]{eventClazz.getName(), sourceClazz != null ? sourceClazz.getName() : "ANY", selInstance.getClass().getName()});
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConfigurationException(cnfe);
            }
        }
    }

    private void processViewHandlers(ServletContext servletContext, FacesContext facesContext, Application application, LinkedHashMap<String, Node> viewHandlers) {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        if (!webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler) && !webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandlerDeprecated) && viewHandlers.containsKey("com.sun.facelets.FaceletViewHandler")) {
            LOGGER.log(Level.WARNING, "jsf.application.legacy_facelet_viewhandler_detected", "com.sun.facelets.FaceletViewHandler");
            webConfig.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler, true);
        }
        for (Node viewHandlerNode : viewHandlers.values()) {
            this.setViewHandler(servletContext, facesContext, application, viewHandlerNode);
        }
    }
}

