/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import jakarta.servlet.AsyncListener;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.as.web.common.WebComponentDescription;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.TagMetaData;
import org.jboss.metadata.web.spec.TldMetaData;
import org.wildfly.extension.undertow.deployment.TldsMetaData;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class WebComponentProcessor
implements DeploymentUnitProcessor {
    private static final String[] BUILTIN_TAGLIBS = new String[]{"org.apache.taglibs.standard", "com.sun.faces.taglib.jsf_core", "com.sun.faces.ext.taglib", "com.sun.faces.taglib.html_basic"};
    private static final DotName ASYNC_LISTENER_INTERFACE = DotName.createSimple((String)AsyncListener.class.getName());

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        HashMap<String, ComponentDescription> componentByClass = new HashMap<String, ComponentDescription>();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClassesDescription = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (moduleDescription == null) {
            return;
        }
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            componentByClass.put(component.getComponentClassName(), component);
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        TldsMetaData tldsMetaData = (TldsMetaData)deploymentUnit.getAttachment(TldsMetaData.ATTACHMENT_KEY);
        Set<String> classes = this.getAllComponentClasses(deploymentUnit, compositeIndex, warMetaData, tldsMetaData);
        for (String clazz : classes) {
            if (clazz == null || clazz.trim().isEmpty()) continue;
            ComponentDescription description = (ComponentDescription)componentByClass.get(clazz);
            if (description != null) {
                if (description.getViews().size() == 1) continue;
                throw UndertowLogger.ROOT_LOGGER.wrongComponentType(clazz);
            }
            if (compositeIndex.getClassByName(DotName.createSimple((String)clazz)) == null) {
                boolean found = false;
                for (String pack : BUILTIN_TAGLIBS) {
                    if (!clazz.startsWith(pack)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
            }
            description = new WebComponentDescription(clazz, clazz, moduleDescription, deploymentUnit.getServiceName(), applicationClassesDescription);
            moduleDescription.addComponent(description);
            deploymentUnit.addToAttachmentList(WebComponentDescription.WEB_COMPONENTS, (Object)description.getStartServiceName());
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private Set<String> getAllComponentClasses(DeploymentUnit deploymentUnit, CompositeIndex index, WarMetaData metaData, TldsMetaData tldsMetaData) {
        HashSet<String> classes = new HashSet<String>();
        this.getAllComponentClasses(metaData.getMergedJBossWebMetaData(), classes);
        if (tldsMetaData == null) {
            return classes;
        }
        if (tldsMetaData.getSharedTlds(deploymentUnit) != null) {
            for (TldMetaData tldMetaData : tldsMetaData.getSharedTlds(deploymentUnit)) {
                this.getAllComponentClasses(tldMetaData, classes);
            }
        }
        if (tldsMetaData.getTlds() != null) {
            for (Map.Entry entry : tldsMetaData.getTlds().entrySet()) {
                this.getAllComponentClasses((TldMetaData)entry.getValue(), classes);
            }
        }
        this.getAllAsyncListenerClasses(index, classes);
        return classes;
    }

    private void getAllComponentClasses(JBossWebMetaData metaData, Set<String> classes) {
        if (metaData.getServlets() != null) {
            for (ServletMetaData servlet : metaData.getServlets()) {
                if (servlet.getServletClass() == null) continue;
                classes.add(servlet.getServletClass());
            }
        }
        if (metaData.getFilters() != null) {
            for (FilterMetaData filter : metaData.getFilters()) {
                classes.add(filter.getFilterClass());
            }
        }
        if (metaData.getListeners() != null) {
            for (ListenerMetaData listener : metaData.getListeners()) {
                classes.add(listener.getListenerClass());
            }
        }
    }

    private void getAllComponentClasses(TldMetaData metaData, Set<String> classes) {
        if (metaData.getValidator() != null) {
            classes.add(metaData.getValidator().getValidatorClass());
        }
        if (metaData.getListeners() != null) {
            for (ListenerMetaData listener : metaData.getListeners()) {
                classes.add(listener.getListenerClass());
            }
        }
        if (metaData.getTags() != null) {
            for (TagMetaData tag : metaData.getTags()) {
                classes.add(tag.getTagClass());
            }
        }
    }

    private void getAllAsyncListenerClasses(CompositeIndex index, Set<String> classes) {
        if (index != null) {
            Set classInfos = index.getAllKnownImplementors(ASYNC_LISTENER_INTERFACE);
            for (ClassInfo classInfo : classInfos) {
                if (Modifier.isAbstract(classInfo.flags()) || Modifier.isInterface(classInfo.flags())) continue;
                classes.add(classInfo.name().toString());
            }
        }
    }
}

