/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.jms.JMSException;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.LocalTransaction;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnection;

public class ActiveMQRALocalTransaction
implements LocalTransaction {
    private final ActiveMQRAManagedConnection mc;

    public ActiveMQRALocalTransaction(ActiveMQRAManagedConnection mc) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("constructor(" + mc + ")");
        }
        this.mc = mc;
    }

    public void begin() throws ResourceException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("begin()");
        }
    }

    public void commit() throws ResourceException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("commit()");
        }
        this.mc.lock();
        try {
            if (this.mc.getSession().getTransacted()) {
                this.mc.getSession().commit();
            }
        }
        catch (JMSException e) {
            throw new ResourceException("Could not commit LocalTransaction", (Throwable)e);
        }
        finally {
            this.mc.unlock();
        }
    }

    public void rollback() throws ResourceException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("rollback()");
        }
        this.mc.lock();
        try {
            if (this.mc.getSession().getTransacted()) {
                this.mc.getSession().rollback();
            }
        }
        catch (JMSException ex) {
            throw new ResourceException("Could not rollback LocalTransaction", (Throwable)ex);
        }
        finally {
            this.mc.unlock();
        }
    }
}

