/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.AbstractMediator;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.i18n.ProviderMessages;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

public class PublisherMediator
extends AbstractMediator {
    private PublisherBuilder<? extends Message<?>> publisher;

    public PublisherMediator(MediatorConfiguration configuration) {
        super(configuration);
        if (configuration.shape() != Shape.PUBLISHER) {
            throw ProviderExceptions.ex.illegalArgumentForPublisherShape(configuration.shape());
        }
    }

    @Override
    public PublisherBuilder<? extends Message<?>> getStream() {
        return Objects.requireNonNull(this.publisher);
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    protected <T> Uni<T> invokeBlocking(Object ... args) {
        return super.invokeBlocking(args).onItem().invoke(item -> {
            if (item == null) {
                throw ProviderExceptions.ex.nullPointerOnInvokeBlocking(this.configuration.methodAsString());
            }
        });
    }

    @Override
    public void initialize(Object bean) {
        super.initialize(bean);
        switch (this.configuration.production()) {
            case STREAM_OF_MESSAGE: {
                if (this.configuration.usesBuilderTypes()) {
                    this.produceAPublisherBuilderOfMessages();
                    break;
                }
                this.produceAPublisherOfMessages();
                break;
            }
            case STREAM_OF_PAYLOAD: {
                if (this.configuration.usesBuilderTypes()) {
                    this.produceAPublisherBuilderOfPayloads();
                    break;
                }
                this.produceAPublisherOfPayloads();
                break;
            }
            case INDIVIDUAL_PAYLOAD: {
                this.produceIndividualPayloads();
                break;
            }
            case INDIVIDUAL_MESSAGE: {
                this.produceIndividualMessages();
                break;
            }
            case COMPLETION_STAGE_OF_MESSAGE: {
                this.produceIndividualCompletionStageOfMessages();
                break;
            }
            case COMPLETION_STAGE_OF_PAYLOAD: {
                this.produceIndividualCompletionStageOfPayloads();
                break;
            }
            case UNI_OF_MESSAGE: {
                this.produceIndividualUniOfMessages();
                break;
            }
            case UNI_OF_PAYLOAD: {
                this.produceIndividualUniOfPayloads();
                break;
            }
            default: {
                throw ProviderExceptions.ex.illegalArgumentForUnexpectedProduction(this.configuration.production());
            }
        }
        assert (this.publisher != null);
    }

    private void produceAPublisherBuilderOfMessages() {
        PublisherBuilder builder = (PublisherBuilder)this.invoke(new Object[0]);
        this.setPublisher(builder);
    }

    private void setPublisher(PublisherBuilder<Message<?>> publisher) {
        this.publisher = this.decorate(publisher);
    }

    private <P> void produceAPublisherBuilderOfPayloads() {
        PublisherBuilder builder = (PublisherBuilder)this.invoke(new Object[0]);
        this.setPublisher(builder.map(Message::of));
    }

    private void produceAPublisherOfMessages() {
        this.setPublisher(ReactiveStreams.fromPublisher((Publisher)((Publisher)this.invoke(new Object[0]))));
    }

    private <P> void produceAPublisherOfPayloads() {
        Publisher pub = (Publisher)this.invoke(new Object[0]);
        this.setPublisher(ReactiveStreams.fromPublisher((Publisher)pub).map(Message::of));
    }

    private <T> void produceIndividualMessages() {
        if (this.configuration.isBlocking()) {
            this.setPublisher(ReactiveStreams.generate(() -> this.invokeBlocking(new Object[0])).flatMapCompletionStage(Uni::subscribeAsCompletionStage).map(message -> (Message)message));
        } else {
            this.setPublisher(ReactiveStreams.generate(() -> {
                Message message = (Message)this.invoke(new Object[0]);
                Objects.requireNonNull(message, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
                return message;
            }));
        }
    }

    private <T> void produceIndividualPayloads() {
        if (this.configuration.isBlocking()) {
            this.setPublisher(ReactiveStreams.generate(() -> this.invokeBlocking(new Object[0])).flatMapCompletionStage(Uni::subscribeAsCompletionStage).map(Message::of));
        } else {
            this.setPublisher(ReactiveStreams.generate(() -> this.invoke(new Object[0])).map(Message::of));
        }
    }

    private void produceIndividualCompletionStageOfMessages() {
        this.setPublisher(ReactiveStreams.generate(() -> (CompletionStage)this.invoke(new Object[0])).flatMapCompletionStage(Function.identity()));
    }

    private <P> void produceIndividualCompletionStageOfPayloads() {
        this.setPublisher(ReactiveStreams.generate(() -> (CompletionStage)this.invoke(new Object[0])).flatMapCompletionStage(Function.identity()).map(Message::of));
    }

    private void produceIndividualUniOfMessages() {
        this.setPublisher(ReactiveStreams.generate(() -> {
            Uni uni = (Uni)this.invoke(new Object[0]);
            return uni.subscribeAsCompletionStage();
        }).flatMapCompletionStage(Function.identity()));
    }

    private <P> void produceIndividualUniOfPayloads() {
        this.setPublisher(ReactiveStreams.generate(() -> {
            Uni uni = (Uni)this.invoke(new Object[0]);
            return uni.subscribeAsCompletionStage();
        }).flatMapCompletionStage(Function.identity()).map(Message::of));
    }
}

