/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.time.LocalDateMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.LocalTimeMarshaller;
import protostream.com.google.protobuf.WireFormat;

public class LocalDateTimeMarshaller
implements ProtoStreamMarshaller<LocalDateTime> {
    private static final int DATE_INDEX = 1;
    private static final int TIME_INDEX = 1 + LocalDateMarshaller.INSTANCE.getFields();

    @Override
    public LocalDateTime readFrom(ProtoStreamReader reader) throws IOException {
        LocalDate date = LocalDateMarshaller.INSTANCE.getBuilder();
        LocalTime time = LocalTimeMarshaller.INSTANCE.getBuilder();
        boolean reading = true;
        while (reading) {
            int tag = reader.readTag();
            int index = WireFormat.getTagFieldNumber((int)tag);
            if (index >= 1 && index < TIME_INDEX) {
                date = LocalDateMarshaller.INSTANCE.readField(reader, index - 1, date);
                continue;
            }
            if (index >= TIME_INDEX && index < TIME_INDEX + LocalTimeMarshaller.INSTANCE.getFields()) {
                time = LocalTimeMarshaller.INSTANCE.readField(reader, index - TIME_INDEX, time);
                continue;
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return LocalDateTime.of(date, time);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, LocalDateTime value) throws IOException {
        LocalDateMarshaller.INSTANCE.writeFields(writer, 1, value.toLocalDate());
        LocalTimeMarshaller.INSTANCE.writeFields(writer, TIME_INDEX, value.toLocalTime());
    }

    @Override
    public Class<? extends LocalDateTime> getJavaClass() {
        return LocalDateTime.class;
    }
}

