/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.spec;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jboss.metadata.ejb.common.IEjbJarMetaData;
import org.jboss.metadata.ejb.spec.AbstractEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokeMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarVersion;
import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
import org.jboss.metadata.ejb.spec.InterceptorClassesMetaData;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.metadata.ejb.spec.MessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.spec.RelationsMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.javaee.support.IdMetaDataImplWithDescriptionGroup;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.merge.javaee.support.IdMetaDataImplWithDescriptionGroupMerger;

public class EjbJarMetaData
extends IdMetaDataImplWithDescriptionGroup
implements IEjbJarMetaData<AssemblyDescriptorMetaData, EnterpriseBeansMetaData, AbstractEnterpriseBeanMetaData, EjbJarMetaData> {
    private static final long serialVersionUID = 809339942454480150L;
    private final EjbJarVersion ejbJarVersion;
    private String dtdPublicId;
    private String dtdSystemId;
    private String version;
    private String ejbClientJar;
    private EnterpriseBeansMetaData enterpriseBeans;
    private RelationsMetaData relationships;
    private AssemblyDescriptorMetaData assemblyDescriptor;
    private String moduleName;
    private boolean metadataComplete;
    private InterceptorsMetaData interceptors;
    private String distinctName;
    public static final String LATEST_EJB_JAR_XSD_VERSION = "3.1";

    public EjbJarMetaData(EjbJarVersion ejbJarVersion) {
        this.ejbJarVersion = ejbJarVersion;
    }

    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    public void setMetadataComplete(boolean metadataComplete) {
        this.metadataComplete = metadataComplete;
    }

    @Override
    public InterceptorsMetaData getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(InterceptorsMetaData interceptors) {
        if (interceptors == null) {
            throw new IllegalArgumentException("Null interceptors");
        }
        this.interceptors = interceptors;
    }

    protected void merge(EjbJarMetaData override, EjbJarMetaData original) {
        if (override != null && override.getModuleName() != null) {
            this.setModuleName(override.getModuleName());
        } else if (original != null && original.getModuleName() != null) {
            this.setModuleName(original.getModuleName());
        }
        if (override != null && override.isMetadataComplete()) {
            this.setMetadataComplete(true);
        } else if (original != null && original.isMetadataComplete()) {
            this.setMetadataComplete(true);
        }
        if (override != null && override.getInterceptors() != null) {
            this.interceptors = override.getInterceptors().createMerged(original != null ? original.getInterceptors() : null);
        } else if (original != null && original.getInterceptors() != null) {
            this.interceptors = original.getInterceptors().createMerged(null);
        }
        IdMetaDataImplWithDescriptionGroupMerger.merge((IdMetaDataImplWithDescriptionGroup)this, (IdMetaDataImplWithDescriptionGroup)override, (IdMetaDataImplWithDescriptionGroup)original);
        if (override != null && override.getAssemblyDescriptor() != null) {
            this.assemblyDescriptor = override.getAssemblyDescriptor().createMerged(original != null ? original.getAssemblyDescriptor() : null);
        } else if (original != null && original.getAssemblyDescriptor() != null) {
            this.assemblyDescriptor = original.getAssemblyDescriptor().createMerged(null);
        }
        if (override != null && override.getEjbClientJar() != null) {
            this.setEjbClientJar(override.getEjbClientJar());
        } else if (original != null && original.getEjbClientJar() != null) {
            this.setEjbClientJar(original.getEjbClientJar());
        }
        if (override != null && override.getEnterpriseBeans() != null) {
            this.setEnterpriseBeans(override.getEnterpriseBeans().createMerged(original != null ? original.getEnterpriseBeans() : null));
        } else if (original != null && original.getEnterpriseBeans() != null) {
            this.setEnterpriseBeans(original.getEnterpriseBeans().createMerged(null));
        }
        if (override != null && override.getVersion() != null) {
            this.version = override.getVersion();
        } else if (original != null && original.getVersion() != null) {
            this.version = original.getVersion();
        }
        this.relationships = AbstractEnterpriseBeanMetaData.augment(new RelationsMetaData(), override != null ? override.relationships : null, original != null ? original.relationships : null);
    }

    public void setDTD(String root, String publicId, String systemId) {
        this.dtdPublicId = publicId;
        this.dtdSystemId = systemId;
        if (publicId != null) {
            if (publicId.contains("2.0")) {
                this.setVersion("2.0");
            }
            if (publicId.contains("1.1")) {
                this.setVersion("1.1");
            }
        }
    }

    public String getDtdPublicId() {
        return this.dtdPublicId;
    }

    public String getDtdSystemId() {
        return this.dtdSystemId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Null version");
        }
        this.version = version;
    }

    @Override
    public boolean isEJB1x() {
        return this.ejbJarVersion.equals((Object)EjbJarVersion.EJB_1_1);
    }

    @Override
    public boolean isEJB2x() {
        return this.getEjbJarVersion() == EjbJarVersion.EJB_2_0 || this.getEjbJarVersion() == EjbJarVersion.EJB_2_1;
    }

    @Override
    public boolean isEJB21() {
        return false;
    }

    @Override
    public boolean isEJB3x() {
        return this.isVersionGreaterThanOrEqual(EjbJarVersion.EJB_3_0);
    }

    public boolean isEJB30() {
        return this.ejbJarVersion == EjbJarVersion.EJB_3_0;
    }

    public boolean isEJB31() {
        return this.ejbJarVersion == EjbJarVersion.EJB_3_1;
    }

    public boolean isEJB32() {
        return this.ejbJarVersion == EjbJarVersion.EJB_3_2;
    }

    public boolean isEJB40() {
        return this.ejbJarVersion == EjbJarVersion.EJB_4_0;
    }

    public boolean isVersionGreaterThan(EjbJarVersion version) {
        if (version == null) {
            return false;
        }
        return this.ejbJarVersion.compareTo(version) > 0;
    }

    public boolean isVersionGreaterThanOrEqual(EjbJarVersion version) {
        if (version == null) {
            return false;
        }
        return this.ejbJarVersion.compareTo(version) >= 0;
    }

    @Override
    public String getEjbClientJar() {
        return this.ejbClientJar;
    }

    @Override
    public void setEjbClientJar(String ejbClientJar) {
        if (ejbClientJar == null) {
            throw new IllegalArgumentException("Null ejbClientJar");
        }
        this.ejbClientJar = ejbClientJar;
    }

    @Override
    public EnterpriseBeansMetaData getEnterpriseBeans() {
        return this.enterpriseBeans;
    }

    @Override
    public void setEnterpriseBeans(EnterpriseBeansMetaData enterpriseBeans) {
        if (enterpriseBeans == null) {
            throw new IllegalArgumentException("Null enterpriseBeans");
        }
        this.enterpriseBeans = enterpriseBeans;
        enterpriseBeans.setEjbJarMetaData(this);
    }

    @Override
    public AbstractEnterpriseBeanMetaData getEnterpriseBean(String name) {
        if (this.enterpriseBeans == null) {
            return null;
        }
        return (AbstractEnterpriseBeanMetaData)this.enterpriseBeans.get(name);
    }

    public final EjbJarVersion getEjbJarVersion() {
        return this.ejbJarVersion;
    }

    @Override
    public RelationsMetaData getRelationships() {
        return this.relationships;
    }

    @Override
    public void setRelationships(RelationsMetaData relationships) {
        if (relationships == null) {
            throw new IllegalArgumentException("Null relationships");
        }
        this.relationships = relationships;
    }

    @Override
    public AssemblyDescriptorMetaData getAssemblyDescriptor() {
        return this.assemblyDescriptor;
    }

    @Override
    public void setAssemblyDescriptor(AssemblyDescriptorMetaData assemblyDescriptor) {
        if (assemblyDescriptor == null) {
            throw new IllegalArgumentException("Null assemblyDescriptor");
        }
        this.assemblyDescriptor = assemblyDescriptor;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public static InterceptorsMetaData getInterceptors(String beanName, EjbJarMetaData ejbJarMetaData) {
        InterceptorsMetaData beanApplicableInterceptors = new InterceptorsMetaData();
        if (ejbJarMetaData.getAssemblyDescriptor() == null) {
            return beanApplicableInterceptors;
        }
        InterceptorBindingsMetaData allInterceptorBindings = ejbJarMetaData.getAssemblyDescriptor().getInterceptorBindings();
        if (allInterceptorBindings == null) {
            return beanApplicableInterceptors;
        }
        InterceptorsMetaData allInterceptors = ejbJarMetaData.getInterceptors();
        if (allInterceptors == null || allInterceptors.isEmpty()) {
            return beanApplicableInterceptors;
        }
        return EjbJarMetaData.getInterceptors(beanName, allInterceptors, allInterceptorBindings);
    }

    public static Collection<String> getAllInterceptorClasses(EjbJarMetaData ejbJar) {
        EnterpriseBeansMetaData enterpriseBeans;
        InterceptorBindingsMetaData interceptorBindings;
        AssemblyDescriptorMetaData assemblyDescriptor;
        HashSet<String> allInterceptorClassNames = new HashSet<String>();
        InterceptorsMetaData interceptorsMetadata = ejbJar.getInterceptors();
        if (interceptorsMetadata != null) {
            Iterator iterator = interceptorsMetadata.iterator();
            while (iterator.hasNext()) {
                InterceptorMetaData interceptor = (InterceptorMetaData)((Object)iterator.next());
                if (interceptor.getInterceptorClass() == null) continue;
                allInterceptorClassNames.add(interceptor.getInterceptorClass());
            }
        }
        if ((assemblyDescriptor = ejbJar.getAssemblyDescriptor()) != null && (interceptorBindings = assemblyDescriptor.getInterceptorBindings()) != null) {
            for (InterceptorBindingMetaData interceptorBinding : interceptorBindings) {
                InterceptorClassesMetaData interceptorClasses;
                if (interceptorBinding == null || (interceptorClasses = interceptorBinding.getInterceptorClasses()) == null) continue;
                for (String interceptorClass : interceptorClasses) {
                    allInterceptorClassNames.add(interceptorClass);
                }
            }
        }
        if ((enterpriseBeans = ejbJar.getEnterpriseBeans()) != null) {
            for (AbstractEnterpriseBeanMetaData enterpriseBean : enterpriseBeans) {
                String enterpriseBeanClassName = enterpriseBean.getEjbClass();
                AroundInvokesMetaData aroundInvokes = null;
                if (enterpriseBean.isSession()) {
                    SessionBeanMetaData sessionBean = (SessionBeanMetaData)((Object)enterpriseBean);
                    aroundInvokes = sessionBean.getAroundInvokes();
                } else if (enterpriseBean.isMessageDriven()) {
                    MessageDrivenBeanMetaData messageDrivenBean = (MessageDrivenBeanMetaData)((Object)enterpriseBean);
                    aroundInvokes = messageDrivenBean.getAroundInvokes();
                }
                if (aroundInvokes == null || aroundInvokes.isEmpty()) continue;
                for (AroundInvokeMetaData aroundInvoke : aroundInvokes) {
                    String targetClass = aroundInvoke.getClassName();
                    if (targetClass == null || targetClass.equals(enterpriseBeanClassName)) continue;
                    allInterceptorClassNames.add(targetClass);
                }
            }
        }
        return allInterceptorClassNames;
    }

    private static InterceptorsMetaData getInterceptors(String ejbName, InterceptorsMetaData allInterceptors, InterceptorBindingsMetaData allInterceptorBindings) {
        InterceptorsMetaData beanApplicableInterceptors = new InterceptorsMetaData();
        boolean includeDefaultInterceptors = false;
        InterceptorsMetaData defaultInterceptors = new InterceptorsMetaData();
        for (InterceptorBindingMetaData binding : allInterceptorBindings) {
            InterceptorMetaData interceptorMetaData;
            InterceptorClassesMetaData interceptorClasses;
            if (ejbName != null && ejbName.equals(binding.getEjbName())) {
                if (!binding.isExcludeDefaultInterceptors()) {
                    includeDefaultInterceptors = true;
                }
                if ((interceptorClasses = binding.getInterceptorClasses()) == null || interceptorClasses.isEmpty()) continue;
                for (String interceptorClass : interceptorClasses) {
                    interceptorMetaData = (InterceptorMetaData)allInterceptors.get(interceptorClass);
                    if (interceptorMetaData == null) continue;
                    beanApplicableInterceptors.add((MappableMetaData)interceptorMetaData);
                }
                continue;
            }
            if (!binding.getEjbName().equals("*") || (interceptorClasses = binding.getInterceptorClasses()) == null || interceptorClasses.isEmpty()) continue;
            for (String interceptorClass : interceptorClasses) {
                interceptorMetaData = (InterceptorMetaData)allInterceptors.get(interceptorClass);
                if (interceptorMetaData == null) continue;
                defaultInterceptors.add((MappableMetaData)interceptorMetaData);
            }
        }
        if (includeDefaultInterceptors) {
            beanApplicableInterceptors.addAll((Collection)((Object)defaultInterceptors));
        }
        return beanApplicableInterceptors;
    }

    public EjbJarMetaData createMerged(EjbJarMetaData original) {
        EjbJarMetaData merged = new EjbJarMetaData(original.getEjbJarVersion());
        merged.merge(this, original);
        return merged;
    }

    public void setDistinctName(String distinctName) {
        this.distinctName = distinctName;
    }

    public String getDistinctName() {
        return this.distinctName;
    }
}

