/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors.encoding;

import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.util.CommitHeaderOutputStream;

@Provider
@Priority(value=4000)
public class GZIPEncodingInterceptor
implements WriterInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : aroundWriteTo", this.getClass().getName());
        Object encoding = context.getHeaders().getFirst((Object)"Content-Encoding");
        if (encoding != null && encoding.toString().equalsIgnoreCase("gzip")) {
            OutputStream old = context.getOutputStream();
            CommittedGZIPOutputStream gzipOutputStream = new CommittedGZIPOutputStream(old, null);
            context.getHeaders().remove((Object)"Content-Length");
            context.setOutputStream((OutputStream)gzipOutputStream);
            try {
                context.proceed();
            }
            finally {
                if (gzipOutputStream.getGzip() != null) {
                    gzipOutputStream.getGzip().finish();
                }
                context.setOutputStream(old);
            }
            return;
        }
        context.proceed();
    }

    public static class CommittedGZIPOutputStream
    extends CommitHeaderOutputStream {
        protected GZIPOutputStream gzip;

        protected CommittedGZIPOutputStream(OutputStream delegate, CommitHeaderOutputStream.CommitCallback headers) {
            super(delegate, headers);
        }

        public GZIPOutputStream getGzip() {
            return this.gzip;
        }

        @Override
        public synchronized void commit() {
            if (this.isHeadersCommitted) {
                return;
            }
            this.isHeadersCommitted = true;
            try {
                this.gzip = new EndableGZIPOutputStream(this.delegate);
                this.delegate = this.gzip;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class EndableGZIPOutputStream
    extends GZIPOutputStream {
        public EndableGZIPOutputStream(OutputStream os) throws IOException {
            super(os);
        }

        @Override
        public void finish() throws IOException {
            super.finish();
            this.def.end();
        }
    }
}

