/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wst11.at.context;

import com.arjuna.ats.arjuna.coordinator.ActionHierarchy;
import com.arjuna.mw.wsas.UserActivityFactory;
import com.arjuna.mw.wsas.activity.ActivityHierarchy;
import com.arjuna.mw.wsas.context.Context;
import com.arjuna.mw.wsas.context.ContextManager;
import com.arjuna.mw.wsas.context.soap.SOAPContext;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wscf.utils.DomUtil;
import com.arjuna.mw.wstx.logging.wstxLogger;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.ATCoordinator;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ArjunaContextImple
implements SOAPContext {
    public static final String serviceType = "TwoPhase11HLS";
    public static final String coordinationType = "http://docs.oasis-open.org/ws-tx/wsat/2006/06";
    private Element _context = null;
    private String[] _identifierValues;
    private int[] _expiresValues;
    private static final String _wscoorNamespace = "http://docs.oasis-open.org/ws-tx/wscoor/2006/06";
    private static final String _wsuNamespace = "http://schemas.xmlsoap.org/ws/2002/07/utility";
    private static final String _arjunaNamespace = "http://arjuna.com/schemas/wsc/2003/01/extension";
    private static final String _contextName = "CoordinationContext";
    private static final String _identifier = "Identifier";
    private static final String _expires = "Expires";
    private static final String _coordinationType = "CoordinationType";

    public ArjunaContextImple() {
    }

    public ArjunaContextImple(ATCoordinator currentCoordinator) {
        this.initialiseContext((Object)currentCoordinator);
    }

    @Override
    public Element serialiseToElement(Element element) {
        Element context = this.context();
        element.appendChild(context);
        return context;
    }

    @Override
    public void initialiseContext(Object param) {
        try {
            ATCoordinator currentCoordinator = (ATCoordinator)((Object)param);
            ActivityHierarchy hier = null;
            try {
                hier = UserActivityFactory.userActivity().currentActivity();
            }
            catch (SystemException ex) {
                ex.printStackTrace();
            }
            if (currentCoordinator != null && hier != null) {
                ActionHierarchy txHier = currentCoordinator.getHierarchy();
                int depth = txHier.depth();
                this._identifierValues = new String[depth];
                this._expiresValues = new int[depth];
                this._identifierValues[0] = txHier.getDeepestActionUid().stringForm();
                this._expiresValues[0] = hier.activity(hier.size() - 1).getTimeout();
                int count = 1;
                int index = 0;
                while (count < depth) {
                    this._identifierValues[count] = txHier.getActionUid(index).stringForm();
                    this._expiresValues[count] = hier.activity(index).getTimeout();
                    ++count;
                    ++index;
                }
            }
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException();
        }
    }

    private synchronized Element context() {
        if (this._context == null) {
            DocumentBuilder builder = DomUtil.getDocumentBuilder();
            Document doc = builder.newDocument();
            this._context = doc.createElement("wscoor:CoordinationContext");
            this._context.setAttribute("xmlns:wsu", _wsuNamespace);
            this._context.setAttribute("xmlns:wscoor", _wscoorNamespace);
            this._context.setAttribute("xmlns:arjuna", _arjunaNamespace);
            if (this._identifierValues != null) {
                Element identifier = doc.createElement("wsu:Identifier");
                identifier.appendChild(doc.createTextNode(this._identifierValues[0]));
                this._context.appendChild(identifier);
                Element expires = doc.createElement("wsu:Expires");
                expires.appendChild(doc.createTextNode(Integer.toString(this._expiresValues[0])));
                this._context.appendChild(expires);
                Element coordinationType = doc.createElement("wscoor:CoordinationType");
                coordinationType.appendChild(doc.createTextNode(coordinationType));
                this._context.appendChild(coordinationType);
                int depth = this._identifierValues.length;
                if (depth > 1) {
                    Element extensionRoot = doc.createElement("arjuna:CoordinationContext");
                    for (int count = 1; count < depth; ++count) {
                        identifier = doc.createElement("arjuna:Identifier");
                        identifier.appendChild(doc.createTextNode(this._identifierValues[count]));
                        extensionRoot.appendChild(identifier);
                        expires = doc.createElement("arjuna:Expires");
                        expires.appendChild(doc.createTextNode(Integer.toString(this._expiresValues[count])));
                        extensionRoot.appendChild(expires);
                    }
                    this._context.appendChild(extensionRoot);
                }
            }
        }
        return this._context;
    }

    @Override
    public String identifier() {
        return ArjunaContextImple.class.getName();
    }

    public String getTransactionIdentifier() {
        return this._identifierValues[0];
    }

    public int getTransactionExpires() {
        return this._expiresValues[0];
    }

    public String toString() {
        return DomUtil.nodeAsString(this._context);
    }

    public static ArjunaContextImple getContext() {
        ContextManager cxman = new ContextManager();
        Context context = cxman.context(serviceType);
        if (context instanceof ArjunaContextImple) {
            return (ArjunaContextImple)context;
        }
        wstxLogger.i18NLogger.warn_mwlabs_wst11_at_context_ArjunaContextImple_1(context.toString());
        return null;
    }
}

