/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.common.AbstractConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class SysPropConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = 9167738611308785403L;
    private static final int DEFAULT_ORDINAL = 400;

    SysPropConfigSource() {
        super("SysPropConfigSource", ConfigSourceUtil.getOrdinalFromMap(SysPropConfigSource.getSystemProperties(), (int)400));
    }

    public Map<String, String> getProperties() {
        return SysPropConfigSource.getSystemProperties();
    }

    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    public String getValue(String s) {
        return AccessController.doPrivileged(() -> System.getProperty(s));
    }

    private static Map<String, String> getSystemProperties() {
        return Collections.unmodifiableMap(ConfigSourceUtil.propertiesToMap((Properties)AccessController.doPrivileged(System::getProperties)));
    }
}

