/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms.cli;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.dmr.ModelNode;

class CreateJMSResourceHandler
extends BatchModeCommandHandler {
    public CreateJMSResourceHandler(CommandContext ctx) {
        super(ctx, "create-jms-resource", true);
        this.addRequiredPath("/subsystem=messaging-activemq");
    }

    public ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws OperationFormatException {
        DefaultOperationRequestBuilder builder;
        Map<String, String> props;
        try {
            if (!ctx.getParsedCommandLine().hasProperties()) {
                throw new OperationFormatException("Arguments are missing");
            }
        }
        catch (CommandFormatException e) {
            throw new OperationFormatException(e.getLocalizedMessage());
        }
        String restype = null;
        String propsStr = null;
        String jndiName = null;
        String[] args = ctx.getArgumentsString().split("\\s+");
        int i = 0;
        while (i < args.length) {
            String arg;
            if ((arg = args[i++]).equals("--restype")) {
                if (i >= args.length) continue;
                restype = args[i++];
                continue;
            }
            if (arg.equals("--target") || arg.equals("--description")) continue;
            if (arg.equals("--property")) {
                if (i >= args.length) continue;
                propsStr = args[i++];
                continue;
            }
            if (arg.equals("--enabled")) continue;
            jndiName = arg;
        }
        if (restype == null) {
            throw new OperationFormatException("Required parameter --restype is missing.");
        }
        if (jndiName == null) {
            throw new OperationFormatException("JNDI name is missing.");
        }
        String name = null;
        String serverName = "default";
        if (propsStr != null) {
            props = new HashMap();
            String[] propsArr = propsStr.split(":");
            for (String prop : propsArr) {
                int equalsIndex = prop.indexOf(61);
                if (equalsIndex < 0 || equalsIndex == prop.length() - 1) {
                    throw new OperationFormatException("Failed to parse property '" + prop + "'");
                }
                String propName = prop.substring(0, equalsIndex).trim();
                String propValue = prop.substring(equalsIndex + 1).trim();
                if (propName.isEmpty()) {
                    throw new OperationFormatException("Failed to parse property '" + prop + "'");
                }
                if (propName.equals("imqDestinationName") || propName.equalsIgnoreCase("name")) {
                    name = propValue;
                    continue;
                }
                if (!"ClientId".equals(propName)) continue;
                props.put("client-id", propValue);
            }
        } else {
            props = Collections.emptyMap();
        }
        if (name == null) {
            name = jndiName.replace('/', '_');
        }
        if (restype.equals("jakarta.jms.Queue")) {
            builder = new DefaultOperationRequestBuilder();
            builder.addNode("subsystem", "messaging-activemq");
            builder.addNode("server", serverName);
            builder.addNode("jms-queue", name);
            builder.setOperationName("add");
            builder.getModelNode().get("entries").add(jndiName);
            for (String prop : props.keySet()) {
                builder.addProperty(prop, (String)props.get(prop));
            }
            return builder.buildRequest();
        }
        if (restype.equals("jakarta.jms.Topic")) {
            builder = new DefaultOperationRequestBuilder();
            builder.addNode("subsystem", "messaging-activemq");
            builder.addNode("server", serverName);
            builder.addNode("jms-topic", name);
            builder.setOperationName("add");
            builder.getModelNode().get("entries").add(jndiName);
            for (String prop : props.keySet()) {
                builder.addProperty(prop, (String)props.get(prop));
            }
            return builder.buildRequest();
        }
        if (restype.equals("jakarta.jms.ConnectionFactory") || restype.equals("jakarta.jms.TopicConnectionFactory") || restype.equals("jakarta.jms.QueueConnectionFactory")) {
            builder = new DefaultOperationRequestBuilder();
            builder.addNode("subsystem", "messaging-activemq");
            builder.addNode("server", serverName);
            builder.addNode("connection-factory", name);
            builder.setOperationName("add");
            builder.getModelNode().get("entries").add(jndiName);
            for (String prop : props.keySet()) {
                builder.addProperty(prop, (String)props.get(prop));
            }
            return builder.buildRequest();
        }
        throw new OperationFormatException("Resource type " + restype + " isn't supported.");
    }
}

