/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.delegates;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.Link;
import org.jboss.resteasy.spi.LinkHeader;

public class LinkHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<LinkHeader> {
    public LinkHeader fromString(String value) throws IllegalArgumentException {
        return LinkHeaderDelegate.from(value);
    }

    public static LinkHeader from(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.paramNull());
        }
        Parser parser = new Parser(value);
        parser.parse();
        return parser.getHeader();
    }

    public String toString(LinkHeader value) {
        if (value == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.paramNull());
        }
        return LinkHeaderDelegate.getString(value);
    }

    public static String getString(LinkHeader value) {
        StringBuffer buf = new StringBuffer();
        for (Link link : value.getLinks()) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(link.toString());
        }
        return buf.toString();
    }

    private static class Parser {
        private int curr;
        private String value;
        private LinkHeader header = new LinkHeader();

        Parser(String value) {
            this.value = value;
        }

        public LinkHeader getHeader() {
            return this.header;
        }

        public void parse() {
            String href = null;
            MultivaluedMapImpl<String, String> attributes = new MultivaluedMapImpl<String, String>();
            while (this.curr < this.value.length()) {
                char c = this.value.charAt(this.curr);
                if (c == '<') {
                    if (href != null) {
                        throw new IllegalArgumentException(Messages.MESSAGES.unableToParseLinkHeaderTooManyLinks(this.value));
                    }
                    href = this.parseLink();
                    continue;
                }
                if (c == ';' || c == ' ') {
                    ++this.curr;
                    continue;
                }
                if (c == ',') {
                    this.populateLink(href, attributes);
                    href = null;
                    attributes = new MultivaluedMapImpl();
                    ++this.curr;
                    continue;
                }
                this.parseAttribute(attributes);
            }
            this.populateLink(href, attributes);
        }

        protected void populateLink(String href, MultivaluedMap<String, String> attributes) {
            String type;
            List rels = (List)attributes.get((Object)"rel");
            List revs = (List)attributes.get((Object)"rev");
            String title = (String)attributes.getFirst((Object)"title");
            if (title != null) {
                attributes.remove((Object)"title");
            }
            if ((type = (String)attributes.getFirst((Object)"type")) != null) {
                attributes.remove((Object)"type");
            }
            HashSet relationships = new HashSet();
            if (rels != null) {
                relationships.addAll(rels);
                attributes.remove((Object)"rel");
            }
            if (revs != null) {
                relationships.addAll(revs);
                attributes.remove((Object)"rev");
            }
            for (String relationship : relationships) {
                StringTokenizer tokenizer = new StringTokenizer(relationship);
                while (tokenizer.hasMoreTokens()) {
                    String rel = tokenizer.nextToken();
                    Link link = new Link(title, rel, href, type, attributes);
                    this.header.getLinksByRelationship().put(rel, link);
                    this.header.getLinksByTitle().put(title, link);
                    this.header.getLinks().add(link);
                }
            }
        }

        public String parseLink() {
            int end = this.value.indexOf(62, this.curr);
            if (end == -1) {
                throw new IllegalArgumentException(Messages.MESSAGES.unableToParseLinkHeaderNoEndToLink(this.value));
            }
            String href = this.value.substring(this.curr + 1, end);
            this.curr = end + 1;
            return href;
        }

        public void parseAttribute(MultivaluedMap<String, String> attributes) {
            int end = this.value.indexOf(61, this.curr);
            if (end == -1 || end + 1 >= this.value.length()) {
                throw new IllegalArgumentException(Messages.MESSAGES.unableToParseLinkHeaderNoEndToParameter(this.value));
            }
            String name = this.value.substring(this.curr, end);
            name = name.trim();
            this.curr = end + 1;
            String val = null;
            if (this.curr >= this.value.length()) {
                val = "";
            } else if (this.value.charAt(this.curr) == '\"') {
                if (this.curr + 1 >= this.value.length()) {
                    throw new IllegalArgumentException(Messages.MESSAGES.unableToParseLinkHeaderNoEndToParameter(this.value));
                }
                ++this.curr;
                end = this.value.indexOf(34, this.curr);
                if (end == -1) {
                    throw new IllegalArgumentException(Messages.MESSAGES.unableToParseLinkHeaderNoEndToParameter(this.value));
                }
                val = this.value.substring(this.curr, end);
                this.curr = end + 1;
            } else {
                char c;
                StringBuffer buf = new StringBuffer();
                while (this.curr < this.value.length() && (c = this.value.charAt(this.curr)) != ',' && c != ';') {
                    buf.append(this.value.charAt(this.curr));
                    ++this.curr;
                }
                val = buf.toString();
            }
            attributes.add((Object)name, (Object)val);
        }
    }
}

