/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.config;

import jakarta.servlet.ServletContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.eclipse.microprofile.config.Config;
import org.jboss.resteasy.microprofile.config.ResteasyConfigProvider;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ResteasyConfig {
    private Config config;

    public ResteasyConfig() {
        try {
            Class.forName("org.eclipse.microprofile.config.spi.ConfigSource");
            Class.forName("org.jboss.resteasy.microprofile.config.ServletConfigSourceImpl");
            this.config = ResteasyConfigProvider.getConfig();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getValue(String propertyName) {
        return this.config == null ? null : (String)this.config.getOptionalValue(propertyName, String.class).orElse(null);
    }

    public String getValue(String propertyName, SOURCE source) {
        return this.getValue(propertyName, source, null);
    }

    public String getValue(final String propertyName, final SOURCE source, final String defaultValue) {
        if (System.getSecurityManager() == null) {
            return this.getValue0(propertyName, source, defaultValue);
        }
        String value = null;
        try {
            value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return ResteasyConfig.this.getValue0(propertyName, source, defaultValue);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae);
        }
        return value;
    }

    public String getValue0(String propertyName, SOURCE source, String defaultValue) {
        if (this.config == null) {
            switch (source) {
                case SYSTEM: {
                    return System.getProperty(propertyName, defaultValue);
                }
                case ENV: {
                    String value = System.getenv(propertyName);
                    return value != null ? value : defaultValue;
                }
                case SERVLET_CONTEXT: {
                    ServletContext context = ResteasyProviderFactory.getContextData(ServletContext.class);
                    if (context != null) {
                        String value = context.getInitParameter(propertyName);
                        return value != null ? value : defaultValue;
                    }
                    return defaultValue;
                }
            }
            throw new RuntimeException(Messages.MESSAGES.unknownEnumerationValue(source.toString()));
        }
        return this.config.getOptionalValue(propertyName, String.class).orElse(defaultValue);
    }

    public Iterable<String> getPropertyNames() {
        return this.config == null ? null : this.getPropertyNames0();
    }

    public Iterable<String> getPropertyNames0() {
        if (System.getSecurityManager() == null) {
            return this.config.getPropertyNames();
        }
        Iterable<String> value = null;
        try {
            value = AccessController.doPrivileged(new PrivilegedExceptionAction<Iterable<String>>(){

                @Override
                public Iterable<String> run() throws Exception {
                    return ResteasyConfig.this.config.getPropertyNames();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae);
        }
        return value;
    }

    public static enum SOURCE {
        SYSTEM,
        ENV,
        SERVLET_CONTEXT;

    }
}

