/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.core.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.core.interception.LegacyPrecedence;
import org.jboss.resteasy.core.interception.PostMatchContainerRequestContext;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;

public class ContainerRequestFilterRegistry
extends JaxrsInterceptorRegistry<ContainerRequestFilter> {
    protected LegacyPrecedence precedence;

    public ContainerRequestFilterRegistry(ResteasyProviderFactory providerFactory, LegacyPrecedence precedence) {
        super(providerFactory, ContainerRequestFilter.class);
        this.precedence = precedence;
    }

    public ContainerRequestFilterRegistry clone(ResteasyProviderFactory factory) {
        ContainerRequestFilterRegistry clone = new ContainerRequestFilterRegistry(factory, this.precedence);
        clone.interceptors.addAll(this.interceptors);
        return clone;
    }

    public ContainerRequestFilter[] postMatch(Class declaring, AccessibleObject target) {
        return (ContainerRequestFilter[])super.postMatch(declaring, target);
    }

    public void registerLegacy(Class<? extends PreProcessInterceptor> decl) {
        this.register(new JaxrsInterceptorRegistry.LegacyPerMethodInterceptorFactory(decl, this.precedence){

            @Override
            public JaxrsInterceptorRegistry.Match postMatch(Class declaring, AccessibleObject target) {
                Object obj = super.getLegacyMatch(declaring, target);
                if (obj == null) {
                    return null;
                }
                PreProcessInterceptor interceptor = (PreProcessInterceptor)obj;
                return new JaxrsInterceptorRegistry.Match(new ContainerRequestFilterFacade(interceptor), this.order);
            }
        });
    }

    public void registerLegacy(PreProcessInterceptor interceptor) {
        this.register(new JaxrsInterceptorRegistry.LegacySingletonInterceptorFactory(interceptor.getClass(), (Object)interceptor, this.precedence){

            @Override
            public JaxrsInterceptorRegistry.Match postMatch(Class declaring, AccessibleObject target) {
                Object obj = super.getLegacyMatch(declaring, target);
                if (obj == null) {
                    return null;
                }
                PreProcessInterceptor interceptor = (PreProcessInterceptor)obj;
                return new JaxrsInterceptorRegistry.Match(new ContainerRequestFilterFacade(interceptor), this.order);
            }
        });
    }

    private static class ContainerRequestFilterFacade
    implements ContainerRequestFilter {
        protected final PreProcessInterceptor interceptor;

        private ContainerRequestFilterFacade(PreProcessInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            PostMatchContainerRequestContext ctx = (PostMatchContainerRequestContext)requestContext;
            ServerResponse response = this.interceptor.preProcess(ctx.getHttpRequest(), ctx.getResourceMethod());
            if (response != null) {
                requestContext.abortWith((Response)response);
            }
        }
    }
}

