/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.impl.table;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.persistence.jdbc.JdbcUtil;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.jdbc.impl.table.TableName;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.spi.PersistenceException;

public abstract class AbstractTableManager
implements TableManager {
    private static final String DEFAULT_IDENTIFIER_QUOTE_STRING = "\"";
    private final Log log;
    protected final ConnectionFactory connectionFactory;
    protected final TableManipulationConfiguration config;
    protected final String timestampIndexExt = "timestamp_index";
    protected final String segmentIndexExt = "segment_index";
    protected final String identifierQuoteString;
    protected final DbMetaData metaData;
    protected final TableName tableName;
    private final String insertRowSql;
    private final String updateRowSql;
    private final String upsertRowSql;
    private final String selectRowSql;
    private final String selectIdRowSql;
    private final String deleteRowSql;
    private final String loadAllRowsSql;
    private final String countRowsSql;
    private final String loadAllNonExpiredRowsSql;
    private final String deleteAllRows;
    private final String selectExpiredRowsSql;

    AbstractTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData, String cacheName, Log log) {
        this(connectionFactory, config, metaData, cacheName, DEFAULT_IDENTIFIER_QUOTE_STRING, log);
    }

    AbstractTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData, String cacheName, String identifierQuoteString, Log log) {
        if (cacheName == null || cacheName.trim().length() == 0) {
            throw new PersistenceException("cacheName needed in order to create table");
        }
        this.connectionFactory = connectionFactory;
        this.config = config;
        this.metaData = metaData;
        this.tableName = new TableName(identifierQuoteString, config.tableNamePrefix(), cacheName);
        this.identifierQuoteString = identifierQuoteString;
        this.log = log;
        this.insertRowSql = this.initInsertRowSql();
        this.updateRowSql = this.initUpdateRowSql();
        this.upsertRowSql = this.initUpsertRowSql();
        this.selectRowSql = this.initSelectRowSql();
        this.selectIdRowSql = this.initSelectIdRowSql();
        this.deleteRowSql = this.initDeleteRowSql();
        this.loadAllRowsSql = this.initLoadAllRowsSql();
        this.countRowsSql = this.initCountNonExpiredRowsSql();
        this.loadAllNonExpiredRowsSql = this.initLoadNonExpiredAllRowsSql();
        this.deleteAllRows = this.initDeleteAllRowsSql();
        this.selectExpiredRowsSql = this.initSelectOnlyExpiredRowsSql();
    }

    @Override
    public void start() throws PersistenceException {
        if (this.config.createOnStart()) {
            Connection conn = null;
            try {
                conn = this.connectionFactory.getConnection();
                if (!this.tableExists(conn)) {
                    this.createTable(conn);
                }
                this.createIndex(conn, "timestamp_index", this.config.timestampColumnName());
                if (!this.metaData.isSegmentedDisabled()) {
                    this.createIndex(conn, "segment_index", this.config.segmentColumnName());
                }
            }
            finally {
                this.connectionFactory.releaseConnection(conn);
            }
        }
    }

    @Override
    public void stop() throws PersistenceException {
        if (this.config.dropOnExit()) {
            Connection conn = null;
            try {
                conn = this.connectionFactory.getConnection();
                this.dropTable(conn);
            }
            finally {
                this.connectionFactory.releaseConnection(conn);
            }
        }
    }

    @Override
    public boolean tableExists(Connection connection) throws PersistenceException {
        return this.tableExists(connection, this.tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tableExists(Connection connection, TableName tableName) throws PersistenceException {
        Objects.requireNonNull(tableName, "table name is mandatory");
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String schemaPattern = tableName.getSchema();
            rs = metaData.getTables(null, schemaPattern, tableName.getName(), new String[]{"TABLE"});
            boolean bl = rs.next();
            JdbcUtil.safeClose(rs);
            return bl;
        }
        catch (SQLException e) {
            if (this.log.isTraceEnabled()) {
                this.log.tracef(e, "SQLException occurs while checking the table %s", tableName);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            JdbcUtil.safeClose(rs);
        }
    }

    @Override
    public void createTable(Connection conn) throws PersistenceException {
        String ddl = this.metaData.isSegmentedDisabled() ? String.format("CREATE TABLE %1$s (%2$s %3$s NOT NULL, %4$s %5$s NOT NULL, %6$s %7$s NOT NULL, PRIMARY KEY (%2$s))", this.tableName, this.config.idColumnName(), this.config.idColumnType(), this.config.dataColumnName(), this.config.dataColumnType(), this.config.timestampColumnName(), this.config.timestampColumnType()) : String.format("CREATE TABLE %1$s (%2$s %3$s NOT NULL, %4$s %5$s NOT NULL, %6$s %7$s NOT NULL, %8$s %9$s NOT NULL, PRIMARY KEY (%2$s))", this.tableName, this.config.idColumnName(), this.config.idColumnType(), this.config.dataColumnName(), this.config.dataColumnType(), this.config.timestampColumnName(), this.config.timestampColumnType(), this.config.segmentColumnName(), this.config.segmentColumnType());
        if (this.log.isTraceEnabled()) {
            this.log.tracef("Creating table with following DDL: '%s'.", ddl);
        }
        this.executeUpdateSql(conn, ddl);
    }

    private void createIndex(Connection conn, String indexExt, String columnName) throws PersistenceException {
        if (this.metaData.isIndexingDisabled()) {
            return;
        }
        boolean indexExists = this.indexExists(this.getIndexName(false, indexExt), conn);
        if (!indexExists) {
            String ddl = String.format("CREATE INDEX %s ON %s (%s)", this.getIndexName(true, indexExt), this.tableName, columnName);
            if (this.log.isTraceEnabled()) {
                this.log.tracef("Adding index with following DDL: '%s'.", ddl);
            }
            this.executeUpdateSql(conn, ddl);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean indexExists(String indexName, Connection conn) throws PersistenceException {
        ResultSet rs;
        block6: {
            boolean bl;
            block5: {
                rs = null;
                try {
                    DatabaseMetaData meta = conn.getMetaData();
                    rs = meta.getIndexInfo(null, this.tableName.getSchema(), this.tableName.getName(), false, false);
                    while (rs.next()) {
                        if (!indexName.equalsIgnoreCase(rs.getString("INDEX_NAME"))) continue;
                        bl = true;
                        break block5;
                    }
                    break block6;
                }
                catch (SQLException e) {
                    try {
                        throw new PersistenceException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        JdbcUtil.safeClose(rs);
                        throw throwable;
                    }
                }
            }
            JdbcUtil.safeClose(rs);
            return bl;
        }
        JdbcUtil.safeClose(rs);
        return false;
    }

    public void executeUpdateSql(Connection conn, String sql) throws PersistenceException {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            Log.PERSISTENCE.errorCreatingTable(sql, e);
            throw new PersistenceException((Throwable)e);
        }
        finally {
            JdbcUtil.safeClose(statement);
        }
    }

    @Override
    public void dropTable(Connection conn) throws PersistenceException {
        this.dropIndex(conn, "timestamp_index");
        this.dropIndex(conn, "segment_index");
        String clearTable = "DELETE FROM " + this.tableName;
        this.executeUpdateSql(conn, clearTable);
        String dropTableDdl = "DROP TABLE " + this.tableName;
        if (this.log.isTraceEnabled()) {
            this.log.tracef("Dropping table with following DDL '%s'", dropTableDdl);
        }
        this.executeUpdateSql(conn, dropTableDdl);
    }

    protected void dropIndex(Connection conn, String indexName) throws PersistenceException {
        if (!this.indexExists(this.getIndexName(true, indexName), conn)) {
            return;
        }
        String dropIndexDdl = this.getDropTimestampSql(indexName);
        if (this.log.isTraceEnabled()) {
            this.log.tracef("Dropping timestamp index with '%s'", dropIndexDdl);
        }
        this.executeUpdateSql(conn, dropIndexDdl);
    }

    protected String getDropTimestampSql(String indexName) {
        return String.format("DROP INDEX %s ON %s", this.getIndexName(true, indexName), this.tableName);
    }

    @Override
    public int getFetchSize() {
        return this.config.fetchSize();
    }

    public int getBatchSize() {
        return this.config.batchSize();
    }

    @Override
    public boolean isUpsertSupported() {
        return !this.metaData.isUpsertDisabled();
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    public String getIndexName(boolean withIdentifier, String indexExt) {
        String plainTableName = this.tableName.toString().replace(this.identifierQuoteString, "");
        String indexName = plainTableName + "_" + indexExt;
        if (withIdentifier) {
            return this.identifierQuoteString + indexName + this.identifierQuoteString;
        }
        return indexName;
    }

    protected String initInsertRowSql() {
        if (this.metaData.isSegmentedDisabled()) {
            return String.format("INSERT INTO %s (%s,%s,%s) VALUES (?,?,?)", this.tableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return String.format("INSERT INTO %s (%s,%s,%s,%s) VALUES (?,?,?,?)", this.tableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.segmentColumnName());
    }

    @Override
    public String getInsertRowSql() {
        return this.insertRowSql;
    }

    protected String initUpdateRowSql() {
        return String.format("UPDATE %s SET %s = ? , %s = ? WHERE %s = ?", this.tableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
    }

    @Override
    public String getUpdateRowSql() {
        return this.updateRowSql;
    }

    protected String initSelectRowSql() {
        return String.format("SELECT %s, %s FROM %s WHERE %s = ?", this.config.idColumnName(), this.config.dataColumnName(), this.tableName, this.config.idColumnName());
    }

    @Override
    public String getSelectRowSql() {
        return this.selectRowSql;
    }

    protected String initSelectIdRowSql() {
        return String.format("SELECT %s FROM %s WHERE %s = ?", this.config.idColumnName(), this.tableName, this.config.idColumnName());
    }

    @Override
    public String getSelectIdRowSql() {
        return this.selectIdRowSql;
    }

    protected String initCountNonExpiredRowsSql() {
        return "SELECT COUNT(*) FROM " + this.tableName + " WHERE " + this.config.timestampColumnName() + " < 0 OR " + this.config.timestampColumnName() + " > ?";
    }

    @Override
    public String getCountNonExpiredRowsSql() {
        return this.countRowsSql;
    }

    @Override
    public String getCountNonExpiredRowsSqlForSegments(int numSegments) {
        StringBuilder stringBuilder = new StringBuilder("SELECT COUNT(*) FROM ");
        stringBuilder.append(this.tableName);
        stringBuilder.append(" WHERE (");
        stringBuilder.append(this.config.timestampColumnName());
        stringBuilder.append(" > ? OR ");
        stringBuilder.append(this.config.timestampColumnName());
        stringBuilder.append(" < 0) AND ");
        stringBuilder.append(this.config.segmentColumnName());
        stringBuilder.append(" IN (?");
        for (int i = 1; i < numSegments; ++i) {
            stringBuilder.append(",?");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected String initDeleteRowSql() {
        return String.format("DELETE FROM %s WHERE %s = ?", this.tableName, this.config.idColumnName());
    }

    @Override
    public String getDeleteRowSql() {
        return this.deleteRowSql;
    }

    @Override
    public String getDeleteRowsSqlForSegments(int numSegments) {
        StringBuilder stringBuilder = new StringBuilder("DELETE FROM ");
        stringBuilder.append(this.tableName);
        stringBuilder.append(" WHERE ");
        stringBuilder.append(this.config.segmentColumnName());
        stringBuilder.append(" IN (?");
        for (int i = 1; i < numSegments; ++i) {
            stringBuilder.append(",?");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected String initLoadNonExpiredAllRowsSql() {
        return String.format("SELECT %1$s, %2$s, %3$s FROM %4$s WHERE %3$s > ? OR %3$s < 0", this.config.dataColumnName(), this.config.idColumnName(), this.config.timestampColumnName(), this.tableName);
    }

    @Override
    public String getLoadNonExpiredAllRowsSql() {
        return this.loadAllNonExpiredRowsSql;
    }

    @Override
    public String getLoadNonExpiredRowsSqlForSegments(int numSegments) {
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        stringBuilder.append(this.config.dataColumnName());
        stringBuilder.append(", ");
        stringBuilder.append(this.config.idColumnName());
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.tableName);
        stringBuilder.append(" WHERE (");
        stringBuilder.append(this.config.timestampColumnName());
        stringBuilder.append(" > ? OR ");
        stringBuilder.append(this.config.timestampColumnName());
        stringBuilder.append(" < 0) AND ");
        stringBuilder.append(this.config.segmentColumnName());
        stringBuilder.append(" IN (?");
        for (int i = 1; i < numSegments; ++i) {
            stringBuilder.append(",?");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    protected String initLoadAllRowsSql() {
        return String.format("SELECT %s, %s FROM %s", this.config.dataColumnName(), this.config.idColumnName(), this.tableName);
    }

    @Override
    public String getLoadAllRowsSql() {
        return this.loadAllRowsSql;
    }

    protected String initDeleteAllRowsSql() {
        return "DELETE FROM " + this.tableName;
    }

    @Override
    public String getDeleteAllRowsSql() {
        return this.deleteAllRows;
    }

    protected String initSelectOnlyExpiredRowsSql() {
        return String.format("%1$s WHERE %2$s < ? AND %2$s > 0 FOR UPDATE", this.getLoadAllRowsSql(), this.config.timestampColumnName());
    }

    @Override
    public String getSelectOnlyExpiredRowsSql() {
        return this.selectExpiredRowsSql;
    }

    protected String initUpsertRowSql() {
        if (this.metaData.isSegmentedDisabled()) {
            return String.format("MERGE INTO %1$s USING (VALUES (?, ?, ?)) AS tmp (%2$s, %3$s, %4$s) ON (%2$s = tmp.%2$s) WHEN MATCHED THEN UPDATE SET %3$s = tmp.%3$s, %4$s = tmp.%4$s WHEN NOT MATCHED THEN INSERT (%2$s, %3$s, %4$s) VALUES (tmp.%2$s, tmp.%3$s, tmp.%4$s)", this.tableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName());
        }
        return String.format("MERGE INTO %1$s USING (VALUES (?, ?, ?, ?)) AS tmp (%2$s, %3$s, %4$s, %5$s) ON (%2$s = tmp.%2$s) WHEN MATCHED THEN UPDATE SET %3$s = tmp.%3$s, %4$s = tmp.%4$s, %5$s = tmp.%5$s WHEN NOT MATCHED THEN INSERT (%2$s, %3$s, %4$s, %5$s) VALUES (tmp.%2$s, tmp.%3$s, tmp.%4$s, tmp.%5$s)", this.tableName, this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.segmentColumnName());
    }

    @Override
    public String getUpsertRowSql() {
        return this.upsertRowSql;
    }

    @Override
    public boolean isStringEncodingRequired() {
        return false;
    }

    @Override
    public String encodeString(String string) {
        return string;
    }

    @Override
    public void prepareUpsertStatement(PreparedStatement ps, String key, long timestamp, int segment, ByteBuffer byteBuffer) throws SQLException {
        ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byteBuffer.getBuf(), byteBuffer.getOffset(), byteBuffer.getLength()), byteBuffer.getLength());
        ps.setLong(2, timestamp);
        ps.setString(3, key);
        if (!this.metaData.isSegmentedDisabled()) {
            ps.setInt(4, segment);
        }
    }

    @Override
    public void prepareUpdateStatement(PreparedStatement ps, String key, long timestamp, int segment, ByteBuffer byteBuffer) throws SQLException {
        ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byteBuffer.getBuf(), byteBuffer.getOffset(), byteBuffer.getLength()), byteBuffer.getLength());
        ps.setLong(2, timestamp);
        ps.setString(3, key);
    }
}

