/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import jakarta.ws.rs.client.AsyncInvoker;
import jakarta.ws.rs.client.CompletionStageRxInvoker;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.RxInvoker;
import jakarta.ws.rs.client.RxInvokerProvider;
import jakarta.ws.rs.client.SyncInvoker;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Locale;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.AsynchronousInvoke;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestHeaders;
import org.jboss.resteasy.client.jaxrs.internal.CompletionStageRxInvokerImpl;

public class ClientInvocationBuilder
implements Invocation.Builder {
    protected ClientInvocation invocation;
    private final URI uri;
    private WebTarget target;

    public ClientInvocationBuilder(ResteasyClient client, URI uri, ClientConfiguration configuration) {
        this.invocation = this.createClientInvocation(client, uri, new ClientRequestHeaders(configuration), configuration);
        this.uri = uri;
    }

    protected ClientInvocation createClientInvocation(ResteasyClient client, URI uri, ClientRequestHeaders headers, ClientConfiguration parent) {
        return new ClientInvocation(client, uri, headers, parent);
    }

    public ClientInvocation getInvocation() {
        return this.invocation;
    }

    public void setInvocation(ClientInvocation invocation) {
        this.invocation = invocation;
    }

    public ClientRequestHeaders getHeaders() {
        return this.invocation.headers;
    }

    public ClientInvocation getClientInvocation() {
        return this.invocation;
    }

    public Invocation.Builder accept(String ... mediaTypes) {
        this.getHeaders().accept(mediaTypes);
        return this;
    }

    public Invocation.Builder accept(MediaType ... mediaTypes) {
        this.getHeaders().accept(mediaTypes);
        return this;
    }

    public Invocation.Builder acceptLanguage(Locale ... locales) {
        this.getHeaders().acceptLanguage(locales);
        return this;
    }

    public Invocation.Builder acceptLanguage(String ... locales) {
        this.getHeaders().acceptLanguage(locales);
        return this;
    }

    public Invocation.Builder acceptEncoding(String ... encodings) {
        this.getHeaders().acceptEncoding(encodings);
        return this;
    }

    public Invocation.Builder cookie(Cookie cookie) {
        if (!Cookie.class.equals(cookie.getClass())) {
            cookie = new Cookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getVersion());
        }
        this.getHeaders().cookie(cookie);
        return this;
    }

    public Invocation.Builder cookie(String name, String value) {
        this.getHeaders().cookie(new Cookie(name, value));
        return this;
    }

    public Invocation.Builder cacheControl(CacheControl cacheControl) {
        this.getHeaders().cacheControl(cacheControl);
        return this;
    }

    public Invocation.Builder header(String name, Object value) {
        this.getHeaders().header(name, value);
        return this;
    }

    public Invocation.Builder headers(MultivaluedMap<String, Object> headers) {
        this.getHeaders().setHeaders(headers);
        return this;
    }

    public Invocation build(String method) {
        this.invocation.setMethod(method);
        return this.invocation;
    }

    public Invocation build(String method, Entity<?> entity) {
        this.invocation.setMethod(method);
        this.invocation.setEntity(entity);
        return this.invocation;
    }

    public Invocation buildGet() {
        return this.build("GET");
    }

    public Invocation buildDelete() {
        return this.build("DELETE");
    }

    public Invocation buildPost(Entity<?> entity) {
        return this.build("POST", entity);
    }

    public Invocation buildPut(Entity<?> entity) {
        return this.build("PUT", entity);
    }

    public AsyncInvoker async() {
        return new AsynchronousInvoke(this.invocation);
    }

    public Response get() {
        return this.buildGet().invoke();
    }

    public <T> T get(Class<T> responseType) {
        return (T)this.buildGet().invoke(responseType);
    }

    public <T> T get(GenericType<T> responseType) {
        return (T)this.buildGet().invoke(responseType);
    }

    public Response put(Entity<?> entity) {
        return this.buildPut(entity).invoke();
    }

    public <T> T put(Entity<?> entity, Class<T> responseType) {
        return (T)this.buildPut(entity).invoke(responseType);
    }

    public <T> T put(Entity<?> entity, GenericType<T> responseType) {
        return (T)this.buildPut(entity).invoke(responseType);
    }

    public Response post(Entity<?> entity) {
        return this.buildPost(entity).invoke();
    }

    public <T> T post(Entity<?> entity, Class<T> responseType) {
        return (T)this.buildPost(entity).invoke(responseType);
    }

    public <T> T post(Entity<?> entity, GenericType<T> responseType) {
        return (T)this.buildPost(entity).invoke(responseType);
    }

    public Response delete() {
        return this.buildDelete().invoke();
    }

    public <T> T delete(Class<T> responseType) {
        return (T)this.buildDelete().invoke(responseType);
    }

    public <T> T delete(GenericType<T> responseType) {
        return (T)this.buildDelete().invoke(responseType);
    }

    public Response head() {
        return this.build("HEAD").invoke();
    }

    public Response options() {
        return this.build("OPTIONS").invoke();
    }

    public <T> T options(Class<T> responseType) {
        return (T)this.build("OPTIONS").invoke(responseType);
    }

    public <T> T options(GenericType<T> responseType) {
        return (T)this.build("OPTIONS").invoke(responseType);
    }

    public Response trace() {
        return this.build("TRACE").invoke();
    }

    public <T> T trace(Class<T> responseType) {
        return (T)this.build("TRACE").invoke(responseType);
    }

    public <T> T trace(GenericType<T> responseType) {
        return (T)this.build("TRACE").invoke(responseType);
    }

    public Response method(String name) {
        return this.build(name).invoke();
    }

    public <T> T method(String name, Class<T> responseType) {
        return (T)this.build(name).invoke(responseType);
    }

    public <T> T method(String name, GenericType<T> responseType) {
        return (T)this.build(name).invoke(responseType);
    }

    public Response method(String name, Entity<?> entity) {
        return this.build(name, entity).invoke();
    }

    public <T> T method(String name, Entity<?> entity, Class<T> responseType) {
        return (T)this.build(name, entity).invoke(responseType);
    }

    public <T> T method(String name, Entity<?> entity, GenericType<T> responseType) {
        return (T)this.build(name, entity).invoke(responseType);
    }

    public Invocation.Builder property(String name, Object value) {
        this.invocation.property(name, value);
        return this;
    }

    public boolean isChunked() {
        return this.invocation.isChunked();
    }

    public void setChunked(boolean chunked) {
        this.invocation.setChunked(chunked);
    }

    public CompletionStageRxInvoker rx() {
        return new CompletionStageRxInvokerImpl((SyncInvoker)this, this.invocation.getClient().asyncInvocationExecutor());
    }

    public <T extends RxInvoker> T rx(Class<T> clazz) {
        RxInvokerProvider<T> provider = this.invocation.getClientConfiguration().getRxInvokerProvider(clazz);
        if (provider == null) {
            throw new IllegalStateException(Messages.MESSAGES.unableToInstantiate(clazz));
        }
        return (T)provider.getRxInvoker((SyncInvoker)this, this.invocation.getClient().asyncInvocationExecutor());
    }

    public Response patch(Entity<?> entity) {
        return this.build("PATCH", entity).invoke();
    }

    public <T> T patch(Entity<?> entity, Class<T> responseType) {
        return (T)this.build("PATCH", entity).invoke(responseType);
    }

    public <T> T patch(Entity<?> entity, GenericType<T> responseType) {
        return (T)this.build("PATCH", entity).invoke(responseType);
    }

    public URI getURI() {
        return this.uri;
    }

    public WebTarget getTarget() {
        return this.target;
    }

    public void setTarget(WebTarget target) {
        this.target = target;
    }
}

