/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.cache;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.client.jaxrs.cache.BrowserCache;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.ReadFromStream;

public class CacheInterceptor
implements ClientRequestFilter,
ClientResponseFilter {
    protected BrowserCache cache;

    public CacheInterceptor(BrowserCache cache) {
        LogMessages.LOGGER.debugf("Interceptor : %s,  Method : CacheInterceptor", (Object)this.getClass().getName());
        this.cache = cache;
    }

    public void filter(ClientRequestContext request) throws IOException {
        if (!request.getMethod().equalsIgnoreCase("GET")) {
            return;
        }
        try {
            BrowserCache.Entry entry = this.getEntry(request);
            if (entry == null) {
                return;
            }
            if (entry.expired()) {
                BrowserCache.Header[] headers;
                this.cache.remove(request.getUri().toString(), entry.getMediaType());
                for (BrowserCache.Header header : headers = entry.getValidationHeaders()) {
                    request.getHeaders().putSingle((Object)header.getName(), (Object)header.getValue());
                }
                request.setProperty("expired.cache.entry", (Object)entry);
                return;
            }
            request.setProperty("cached", (Object)"cached");
            request.abortWith(this.cachedResponse(entry));
        }
        catch (IOException io) {
            throw io;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Response cachedResponse(BrowserCache.Entry entry) {
        ByteArrayInputStream bais = new ByteArrayInputStream(entry.getCached());
        Response.ResponseBuilder builder = Response.ok().entity((Object)bais);
        for (Map.Entry header : entry.getHeaders().entrySet()) {
            for (String val : (List)header.getValue()) {
                builder.header((String)header.getKey(), (Object)val);
            }
        }
        return builder.build();
    }

    public void filter(ClientRequestContext request, ClientResponseContext response) throws IOException {
        if (!request.getMethod().equalsIgnoreCase("GET") || request.getProperty("cached") != null) {
            return;
        }
        if (response.getStatus() == 304) {
            BrowserCache.Entry entry = (BrowserCache.Entry)request.getProperty("expired.cache.entry");
            this.updateOnNotModified(request, entry, response);
            return;
        }
        if (response.getStatus() == 200) {
            this.cache(request, response);
        }
    }

    private void useCacheEntry(ClientResponseContext response, BrowserCache.Entry entry) {
        ByteArrayInputStream bais = new ByteArrayInputStream(entry.getCached());
        response.setEntityStream((InputStream)bais);
        response.setStatus(200);
        for (Map.Entry header : entry.getHeaders().entrySet()) {
            response.getHeaders().remove(header.getKey());
            for (String val : (List)header.getValue()) {
                response.getHeaders().add(header.getKey(), (Object)val);
            }
        }
    }

    private void cache(ClientRequestContext request, ClientResponseContext response) throws IOException {
        if (response.getStatus() != 200) {
            return;
        }
        this.cacheIfPossible(request, response);
    }

    public void updateOnNotModified(ClientRequestContext request, BrowserCache.Entry old, ClientResponseContext response) {
        old.getHeaders().remove((Object)"Cache-Control");
        old.getHeaders().remove((Object)"Expires");
        old.getHeaders().remove((Object)"Last-Modified");
        String cc = response.getHeaderString("Cache-Control");
        String exp = response.getHeaderString("Expires");
        int expires = -1;
        if (cc != null) {
            CacheControl cacheControl = CacheControl.valueOf((String)cc);
            if (cacheControl.isNoCache()) {
                this.useCacheEntry(response, old);
                return;
            }
            expires = cacheControl.getMaxAge();
        } else if (exp != null) {
            Date date = DateUtil.parseDate((String)exp);
            expires = (int)((date.getTime() - System.currentTimeMillis()) / 1000L);
        }
        if (cc != null) {
            old.getHeaders().putSingle((Object)"Cache-Control", (Object)cc);
        }
        if (exp != null) {
            old.getHeaders().putSingle((Object)"Cache-Control", (Object)exp);
        }
        String lastModified = response.getHeaderString("Last-Modified");
        String etag = response.getHeaderString("ETag");
        if (etag == null) {
            etag = (String)old.getHeaders().getFirst((Object)"ETag");
        } else {
            old.getHeaders().putSingle((Object)"ETag", (Object)etag);
        }
        if (lastModified != null) {
            old.getHeaders().putSingle((Object)"Last-Modified", (Object)lastModified);
        }
        if (etag == null && lastModified == null && cc == null && exp == null) {
            this.useCacheEntry(response, old);
            return;
        }
        BrowserCache.Entry entry = this.cache.put(request.getUri().toString(), old.getMediaType(), old.getHeaders(), old.getCached(), expires, etag, lastModified);
        this.useCacheEntry(response, entry);
    }

    public void cacheIfPossible(ClientRequestContext request, ClientResponseContext response) throws IOException {
        String cc = response.getHeaderString("Cache-Control");
        String exp = response.getHeaderString("Expires");
        int expires = -1;
        if (cc != null) {
            CacheControl cacheControl = CacheControl.valueOf((String)cc);
            if (cacheControl.isNoCache()) {
                return;
            }
            expires = cacheControl.getMaxAge();
        } else if (exp != null) {
            Date date = DateUtil.parseDate((String)exp);
            expires = (int)((date.getTime() - System.currentTimeMillis()) / 1000L);
        }
        String lastModified = response.getHeaderString("Last-Modified");
        String etag = response.getHeaderString("ETag");
        String contentType = response.getHeaderString("Content-Type");
        String accept = request.getHeaderString("Accept");
        byte[] cached = ReadFromStream.readFromStream((int)1024, (InputStream)response.getEntityStream());
        MediaType mediaType = MediaType.valueOf((String)contentType);
        if (accept != null) {
            for (String acceptItem : accept.split("\\s*,\\s*")) {
                MediaType acceptMediaType = MediaType.valueOf((String)acceptItem);
                if (!mediaType.isCompatible(acceptMediaType)) continue;
                mediaType = acceptMediaType;
                break;
            }
        }
        BrowserCache.Entry entry = this.cache.put(request.getUri().toString(), mediaType, (MultivaluedMap<String, String>)response.getHeaders(), cached, expires, etag, lastModified);
        response.setEntityStream((InputStream)new ByteArrayInputStream(cached));
    }

    protected BrowserCache.Entry getEntry(ClientRequestContext request) throws Exception {
        String uri = request.getUri().toString();
        List acceptableMediaTypes = request.getAcceptableMediaTypes();
        BrowserCache.Entry entry = null;
        if (acceptableMediaTypes.size() > 0) {
            for (MediaType accept : acceptableMediaTypes) {
                entry = this.cache.get(uri, accept);
                if (entry != null) {
                    return entry;
                }
                if (!MediaTypeHelper.isTextLike((MediaType)accept) || (entry = this.cache.get(uri, accept.withCharset("UTF-8"))) == null) continue;
                return entry;
            }
        } else {
            return this.cache.getAny(uri);
        }
        return null;
    }
}

