/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.jta.jms;

import com.arjuna.ats.jta.logging.jtaLogger;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSException;
import jakarta.jms.XAConnectionFactory;
import org.jboss.narayana.jta.jms.ConnectionProxy;
import org.jboss.narayana.jta.jms.TransactionHelper;

public class ConnectionFactoryProxy
implements ConnectionFactory {
    private final XAConnectionFactory xaConnectionFactory;
    private final TransactionHelper transactionHelper;

    public ConnectionFactoryProxy(XAConnectionFactory xaConnectionFactory, TransactionHelper transactionHelper) {
        this.xaConnectionFactory = xaConnectionFactory;
        this.transactionHelper = transactionHelper;
    }

    public Connection createConnection() throws JMSException {
        ConnectionProxy connection = new ConnectionProxy(this.xaConnectionFactory.createXAConnection(), this.transactionHelper);
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("Created new proxied connection: " + connection));
        }
        return connection;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        ConnectionProxy connection = new ConnectionProxy(this.xaConnectionFactory.createXAConnection(userName, password), this.transactionHelper);
        if (jtaLogger.logger.isTraceEnabled()) {
            jtaLogger.logger.trace((Object)("Created new proxied connection: " + connection));
        }
        return connection;
    }
}

