/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v53.impl;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.hibernate.cache.spi.CacheTransactionSynchronization;
import org.hibernate.cache.spi.RegionFactory;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.v53.impl.Invocation;

public class Sync
implements CacheTransactionSynchronization {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(Sync.class);
    private static final boolean trace = log.isTraceEnabled();
    private final RegionFactory regionFactory;
    private long transactionStartTimestamp;
    private Object[] tasks;
    private int index;

    public Sync(RegionFactory regionFactory) {
        this.regionFactory = regionFactory;
        this.transactionStartTimestamp = regionFactory.nextTimestamp();
    }

    public void registerBeforeCommit(CompletableFuture<?> future) {
        this.add(future);
    }

    public void registerAfterCommit(Invocation invocation) {
        assert (!(invocation instanceof CompletableFuture)) : "Invocation must not extend CompletableFuture";
        this.add(invocation);
    }

    private void add(Object task) {
        log.tracef("Adding %08x %s", System.identityHashCode(task), task);
        if (this.tasks == null) {
            this.tasks = new Object[4];
        } else if (this.index == this.tasks.length) {
            this.tasks = Arrays.copyOf(this.tasks, this.tasks.length * 2);
        }
        this.tasks[this.index++] = task;
    }

    public long getCurrentTransactionStartTimestamp() {
        return this.transactionStartTimestamp;
    }

    public void transactionJoined() {
        this.transactionStartTimestamp = this.regionFactory.nextTimestamp();
    }

    public void transactionCompleting() {
        if (trace) {
            int done = 0;
            int notDone = 0;
            for (int i = 0; i < this.index; ++i) {
                Object task = this.tasks[i];
                if (!(task instanceof CompletableFuture)) continue;
                if (((CompletableFuture)task).isDone()) {
                    ++done;
                    continue;
                }
                ++notDone;
            }
            log.tracef("%d tasks done, %d tasks not done yet", done, notDone);
        }
        int count = 0;
        for (int i = 0; i < this.index; ++i) {
            Object task = this.tasks[i];
            if (task instanceof CompletableFuture) {
                log.tracef("Waiting for %08x %s", System.identityHashCode(task), task);
                try {
                    ((CompletableFuture)task).join();
                }
                catch (CompletionException e) {
                    log.debugf("Unable to complete task %08x before commit, rethrow exception", System.identityHashCode(task));
                    throw e;
                }
                this.tasks[i] = null;
                ++count;
                continue;
            }
            log.tracef("Not waiting for %08x %s", System.identityHashCode(task), task);
        }
        if (trace) {
            log.tracef("Finished %d tasks before completion", count);
        }
    }

    public void transactionCompleted(boolean successful) {
        int i;
        if (!successful) {
            this.transactionCompleting();
        }
        int invoked = 0;
        int waiting = 0;
        for (i = 0; i < this.index; ++i) {
            Object invocation = this.tasks[i];
            if (invocation == null) continue;
            try {
                this.tasks[i] = ((Invocation)invocation).invoke(successful);
            }
            catch (Exception e) {
                log.failureAfterTransactionCompletion(i, successful, e);
                this.tasks[i] = null;
            }
            ++invoked;
        }
        for (i = 0; i < this.index; ++i) {
            CompletableFuture cf = (CompletableFuture)this.tasks[i];
            if (cf == null) continue;
            try {
                cf.join();
            }
            catch (Exception e) {
                log.failureAfterTransactionCompletion(i, successful, e);
            }
            ++waiting;
        }
        if (trace) {
            log.tracef("Invoked %d tasks after completion, %d are synchronous.", invoked, waiting);
        }
    }
}

