/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jwe;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.Serializable;
import org.jboss.resteasy.jose.jwe.Algorithm;
import org.jboss.resteasy.jose.jwe.CompressionAlgorithm;
import org.jboss.resteasy.jose.jwe.EncryptionMethod;

public class JWEHeader
implements Serializable {
    @JsonProperty(value="alg")
    private Algorithm algorithm;
    @JsonProperty(value="enc")
    private EncryptionMethod encryptionMethod;
    @JsonProperty(value="typ")
    private String type;
    @JsonProperty(value="cty")
    private String contentType;
    @JsonProperty(value="zip")
    private CompressionAlgorithm compressionAlgorithm;
    private static final ObjectMapper mapper = new ObjectMapper();

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getType() {
        return this.type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public void setCompressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void setEncryptionMethod(EncryptionMethod encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
    }

    @JsonIgnore
    public MediaType getMediaType() {
        if (this.contentType == null) {
            return null;
        }
        return MediaType.valueOf((String)this.contentType);
    }

    public String toString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

