/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.index.impl;

import com.google.common.base.Function;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Set;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.saml.metadata.resolver.index.MetadataIndex;
import org.opensaml.saml.metadata.resolver.index.MetadataIndexKey;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;

public class FunctionDrivenMetadataIndex
implements MetadataIndex {
    @Nonnull
    private Function<CriteriaSet, Set<MetadataIndexKey>> criteriaStrategy;
    @Nonnull
    private Function<EntityDescriptor, Set<MetadataIndexKey>> descriptorStrategy;

    public FunctionDrivenMetadataIndex(@Nonnull Function<EntityDescriptor, Set<MetadataIndexKey>> descriptorFunction, @Nonnull Function<CriteriaSet, Set<MetadataIndexKey>> criteriaFunction) {
        this.descriptorStrategy = (Function)Constraint.isNotNull(descriptorFunction, (String)"EntityDescriptor strategy function was null");
        this.criteriaStrategy = (Function)Constraint.isNotNull(criteriaFunction, (String)"CriteriaSet strategy function was null");
    }

    @Nullable
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Set<MetadataIndexKey> generateKeys(@Nonnull CriteriaSet criteriaSet) {
        Constraint.isNotNull((Object)criteriaSet, (String)"CriteriaSet was null");
        return (Set)this.criteriaStrategy.apply((Object)criteriaSet);
    }

    @Nullable
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Set<MetadataIndexKey> generateKeys(@Nonnull EntityDescriptor descriptor) {
        Constraint.isNotNull((Object)descriptor, (String)"EntityDescriptor was null");
        return (Set)this.descriptorStrategy.apply((Object)descriptor);
    }
}

