/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.outbound;

import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.MessageContext;
import org.jboss.jbossts.txbridge.outbound.OutboundBridge;
import org.jboss.jbossts.txbridge.outbound.OutboundBridgeManager;
import org.jboss.jbossts.txbridge.utils.txbridgeLogger;

public class JaxWSTxOutboundBridgeHandler
implements Handler {
    public boolean handleMessage(MessageContext msgContext) {
        txbridgeLogger.logger.trace((Object)"JaxWSTxOutboundBridgeHandler.handleMessage()");
        Boolean outbound = (Boolean)msgContext.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outbound == null) {
            throw new IllegalStateException("Cannot obtain required property: javax.xml.ws.handler.message.outbound");
        }
        return outbound != false ? this.handleOutbound(msgContext) : this.handleInbound(msgContext);
    }

    public boolean handleFault(MessageContext messageContext) {
        txbridgeLogger.logger.trace((Object)"JaxWSTxOutboundBridgeHandler.handleFault()");
        return this.suspendTransaction();
    }

    public void close(MessageContext messageContext) {
        txbridgeLogger.logger.trace((Object)"JaxWSTxOutboundBridgeHandler.close()");
    }

    protected boolean handleInbound(MessageContext msgContext) {
        txbridgeLogger.logger.trace((Object)"JaxWSTxOutboundBridgeHandler.handleInbound()");
        return this.suspendTransaction();
    }

    protected boolean handleOutbound(MessageContext msgContext) {
        txbridgeLogger.logger.trace((Object)"JaxWSTxOutboundBridgeHandler.handleOutbound()");
        try {
            OutboundBridge outboundBridge = OutboundBridgeManager.getOutboundBridge();
            outboundBridge.start();
        }
        catch (Exception e) {
            txbridgeLogger.logger.error((Object)e);
            return false;
        }
        return true;
    }

    private boolean suspendTransaction() {
        txbridgeLogger.logger.trace((Object)"JaxWSTxOutboundBridgeHandler.suspendTransaction()");
        try {
            OutboundBridge outboundBridge = OutboundBridgeManager.getOutboundBridge();
            outboundBridge.stop();
        }
        catch (Exception e) {
            txbridgeLogger.logger.error((Object)e);
            return false;
        }
        return true;
    }
}

