/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.time.Duration;
import java.util.function.Function;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.hotrod.RemoteCacheMutatorFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaData;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.InvalidatableSessionMetaData;
import org.wildfly.clustering.web.cache.session.MutableSessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.MutableSessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.SessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaData;
import org.wildfly.clustering.web.cache.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.cache.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.cache.session.SimpleSessionAccessMetaData;
import org.wildfly.clustering.web.cache.session.SimpleSessionCreationMetaData;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionMetaDataFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.hotrod.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class HotRodSessionMetaDataFactory<L>
implements SessionMetaDataFactory<CompositeSessionMetaDataEntry<L>> {
    private final RemoteCache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataCache;
    private final MutatorFactory<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataMutatorFactory;
    private final RemoteCache<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataCache;
    private final MutatorFactory<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataMutatorFactory;
    private final CacheProperties properties;

    public HotRodSessionMetaDataFactory(HotRodSessionMetaDataFactoryConfiguration configuration) {
        this.creationMetaDataCache = configuration.getCache();
        this.creationMetaDataMutatorFactory = new RemoteCacheMutatorFactory(this.creationMetaDataCache, new Function<SessionCreationMetaDataEntry<L>, Duration>(){

            @Override
            public Duration apply(SessionCreationMetaDataEntry<L> entry) {
                return entry.getMetaData().getMaxInactiveInterval();
            }
        });
        this.accessMetaDataCache = configuration.getCache();
        this.accessMetaDataMutatorFactory = new RemoteCacheMutatorFactory(this.accessMetaDataCache);
        this.properties = configuration.getCacheProperties();
    }

    public CompositeSessionMetaDataEntry<L> createValue(String id, Void context) {
        SessionCreationMetaDataEntry creationMetaDataEntry = new SessionCreationMetaDataEntry((SessionCreationMetaData)new SimpleSessionCreationMetaData());
        if (this.creationMetaDataCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent((Object)new SessionCreationMetaDataKey(id), (Object)creationMetaDataEntry) != null) {
            return null;
        }
        SimpleSessionAccessMetaData accessMetaData = new SimpleSessionAccessMetaData();
        this.accessMetaDataCache.put((Object)new SessionAccessMetaDataKey(id), (Object)accessMetaData);
        return new CompositeSessionMetaDataEntry(creationMetaDataEntry, (SessionAccessMetaData)accessMetaData);
    }

    public CompositeSessionMetaDataEntry<L> findValue(String id) {
        SessionCreationMetaDataKey key = new SessionCreationMetaDataKey(id);
        MetadataValue value = this.creationMetaDataCache.getWithMetadata((Object)key);
        SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)this.creationMetaDataCache.get((Object)key);
        if (creationMetaDataEntry != null) {
            SessionAccessMetaData accessMetaData = (SessionAccessMetaData)this.accessMetaDataCache.get((Object)new SessionAccessMetaDataKey(id));
            if (accessMetaData != null) {
                return new CompositeSessionMetaDataEntry(creationMetaDataEntry, accessMetaData);
            }
            this.creationMetaDataCache.removeWithVersion((Object)key, value.getVersion());
        }
        return null;
    }

    public InvalidatableSessionMetaData createSessionMetaData(String id, CompositeSessionMetaDataEntry<L> entry) {
        boolean newSession = entry.getCreationMetaData().isNew();
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        Mutator creationMutator = this.properties.isTransactional() && newSession ? Mutator.PASSIVE : this.creationMetaDataMutatorFactory.createMutator((Object)creationMetaDataKey, (Object)new SessionCreationMetaDataEntry(entry.getCreationMetaData(), entry.getLocalContext()));
        MutableSessionCreationMetaData creationMetaData = new MutableSessionCreationMetaData(entry.getCreationMetaData(), creationMutator);
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        Mutator accessMutator = this.properties.isTransactional() && newSession ? Mutator.PASSIVE : this.accessMetaDataMutatorFactory.createMutator((Object)accessMetaDataKey, (Object)entry.getAccessMetaData());
        MutableSessionAccessMetaData accessMetaData = new MutableSessionAccessMetaData(entry.getAccessMetaData(), accessMutator);
        return new CompositeSessionMetaData((SessionCreationMetaData)creationMetaData, (SessionAccessMetaData)accessMetaData);
    }

    public ImmutableSessionMetaData createImmutableSessionMetaData(String id, CompositeSessionMetaDataEntry<L> entry) {
        return new CompositeSessionMetaData(entry.getCreationMetaData(), entry.getAccessMetaData());
    }

    public boolean remove(String id) {
        SessionCreationMetaDataKey key = new SessionCreationMetaDataKey(id);
        SessionCreationMetaDataEntry creationMetaData = (SessionCreationMetaDataEntry)this.creationMetaDataCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)key);
        if (creationMetaData == null) {
            return false;
        }
        this.accessMetaDataCache.remove((Object)new SessionAccessMetaDataKey(id));
        return true;
    }
}

