/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.operation;

import jakarta.xml.bind.JAXBElement;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.QNameConstants;
import org.apache.cxf.sts.operation.AbstractOperation;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenCollectionType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenResponseCollectionType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenResponseType;
import org.apache.cxf.ws.security.sts.provider.model.RequestSecurityTokenType;
import org.apache.cxf.ws.security.sts.provider.operation.CancelOperation;
import org.apache.cxf.ws.security.sts.provider.operation.IssueSingleOperation;
import org.apache.cxf.ws.security.sts.provider.operation.RenewOperation;
import org.apache.cxf.ws.security.sts.provider.operation.RequestCollectionOperation;
import org.apache.cxf.ws.security.sts.provider.operation.ValidateOperation;

public class TokenRequestCollectionOperation
extends AbstractOperation
implements RequestCollectionOperation {
    public static final String WSTRUST_REQUESTTYPE_BATCH_ISSUE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchIssue";
    public static final String WSTRUST_REQUESTTYPE_BATCH_CANCEL = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchCancel";
    public static final String WSTRUST_REQUESTTYPE_BATCH_RENEW = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchRenew";
    public static final String WSTRUST_REQUESTTYPE_BATCH_VALIDATE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/BatchValidate";
    static final Logger LOG = LogUtils.getL7dLogger(TokenRequestCollectionOperation.class);
    private IssueSingleOperation issueSingleOperation;
    private ValidateOperation validateOperation;
    private RenewOperation renewOperation;
    private CancelOperation cancelOperation;

    public RequestSecurityTokenResponseCollectionType requestCollection(RequestSecurityTokenCollectionType requestCollection, Principal principal, Map<String, Object> messageContext) {
        RequestSecurityTokenResponseCollectionType responseCollection = QNameConstants.WS_TRUST_FACTORY.createRequestSecurityTokenResponseCollectionType();
        String requestType = null;
        for (RequestSecurityTokenType request : requestCollection.getRequestSecurityToken()) {
            List objectList = request.getAny();
            for (Object o : objectList) {
                QName qname;
                if (!(o instanceof JAXBElement) || !(qname = ((JAXBElement)o).getName()).equals(new QName("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "RequestType"))) continue;
                String val = ((JAXBElement)o).getValue().toString();
                if (val == null || requestType != null && !requestType.equals(val)) {
                    LOG.log(Level.WARNING, "All RequestSecurityTokenCollection elements do not share the sameRequestType");
                    throw new STSException("Error in requesting a token", STSException.REQUEST_FAILED);
                }
                requestType = val;
            }
            RequestSecurityTokenResponseType response = this.handleRequest(request, principal, messageContext, requestType);
            responseCollection.getRequestSecurityTokenResponse().add(response);
        }
        return responseCollection;
    }

    public RequestSecurityTokenResponseType handleRequest(RequestSecurityTokenType request, Principal principal, Map<String, Object> messageContext, String requestType) {
        if (WSTRUST_REQUESTTYPE_BATCH_ISSUE.equals(requestType)) {
            if (this.issueSingleOperation == null) {
                LOG.log(Level.WARNING, "IssueSingleOperation is null");
                throw new STSException("Error in requesting a token", STSException.REQUEST_FAILED);
            }
            return this.issueSingleOperation.issueSingle(request, principal, messageContext);
        }
        if (WSTRUST_REQUESTTYPE_BATCH_VALIDATE.equals(requestType)) {
            if (this.validateOperation == null) {
                LOG.log(Level.WARNING, "ValidateOperation is null");
                throw new STSException("Error in requesting a token", STSException.REQUEST_FAILED);
            }
            return this.validateOperation.validate(request, principal, messageContext);
        }
        if (WSTRUST_REQUESTTYPE_BATCH_CANCEL.equals(requestType)) {
            if (this.cancelOperation == null) {
                LOG.log(Level.WARNING, "CancelOperation is null");
                throw new STSException("Error in requesting a token", STSException.REQUEST_FAILED);
            }
            return this.cancelOperation.cancel(request, principal, messageContext);
        }
        if (WSTRUST_REQUESTTYPE_BATCH_RENEW.equals(requestType)) {
            if (this.renewOperation == null) {
                LOG.log(Level.WARNING, "RenewOperation is null");
                throw new STSException("Error in requesting a token", STSException.REQUEST_FAILED);
            }
            return this.renewOperation.renew(request, principal, messageContext);
        }
        LOG.log(Level.WARNING, "Unknown operation requested");
        throw new STSException("Error in requesting a token", STSException.REQUEST_FAILED);
    }

    public IssueSingleOperation getIssueSingleOperation() {
        return this.issueSingleOperation;
    }

    public void setIssueSingleOperation(IssueSingleOperation issueSingleOperation) {
        this.issueSingleOperation = issueSingleOperation;
    }

    public ValidateOperation getValidateOperation() {
        return this.validateOperation;
    }

    public void setValidateOperation(ValidateOperation validateOperation) {
        this.validateOperation = validateOperation;
    }

    public RenewOperation getRenewOperation() {
        return this.renewOperation;
    }

    public void setRenewOperation(RenewOperation renewOperation) {
        this.renewOperation = renewOperation;
    }

    public CancelOperation getCancelOperation() {
        return this.cancelOperation;
    }

    public void setCancelOperation(CancelOperation cancelOperation) {
        this.cancelOperation = cancelOperation;
    }
}

