/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import jakarta.security.jacc.PolicyConfiguration;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wildfly.common.Assert;
import org.wildfly.security.authz.jacc.ElytronMessages;
import org.wildfly.security.authz.jacc.ElytronPolicyConfiguration;

public class ElytronPolicyConfigurationFactory
extends PolicyConfigurationFactory {
    public static final PrivilegedAction<String> GET_CONTEXT_ID = () -> PolicyContext.getContextID();
    private static final Map<String, ElytronPolicyConfiguration> configurationRegistry = new ConcurrentHashMap<String, ElytronPolicyConfiguration>();

    static <P extends PolicyConfiguration> P getCurrentPolicyConfiguration() throws PolicyContextException {
        String contextID = System.getSecurityManager() != null ? AccessController.doPrivileged(GET_CONTEXT_ID) : PolicyContext.getContextID();
        if (contextID == null) {
            throw ElytronMessages.log.authzContextIdentifierNotSet();
        }
        try {
            PolicyConfiguration policyConfiguration = configurationRegistry.get(contextID);
            if (policyConfiguration == null) {
                throw ElytronMessages.log.authzInvalidPolicyContextIdentifier(contextID);
            }
            if (!policyConfiguration.inService()) {
                throw ElytronMessages.log.authzPolicyConfigurationNotInService(contextID);
            }
            return (P)policyConfiguration;
        }
        catch (Exception e) {
            throw ElytronMessages.log.authzUnableToObtainPolicyConfiguration(contextID, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyConfiguration getPolicyConfiguration(String contextID, boolean remove) throws PolicyContextException {
        Assert.checkNotNullParam("contextID", contextID);
        Map<String, ElytronPolicyConfiguration> map = configurationRegistry;
        synchronized (map) {
            ElytronPolicyConfiguration policyConfiguration = configurationRegistry.get(contextID);
            if (policyConfiguration == null) {
                return this.createPolicyConfiguration(contextID);
            }
            if (remove) {
                policyConfiguration.delete();
            }
            policyConfiguration.transitionTo(ElytronPolicyConfiguration.State.OPEN);
            return policyConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inService(String contextID) throws PolicyContextException {
        Assert.checkNotNullParam("contextID", contextID);
        Map<String, ElytronPolicyConfiguration> map = configurationRegistry;
        synchronized (map) {
            PolicyConfiguration policyConfiguration = configurationRegistry.get(contextID);
            if (policyConfiguration == null) {
                return false;
            }
            return policyConfiguration.inService();
        }
    }

    private ElytronPolicyConfiguration createPolicyConfiguration(String contextID) {
        return configurationRegistry.computeIfAbsent(contextID, ElytronPolicyConfiguration::new);
    }
}

