/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.jaxrs;

import jakarta.annotation.Priority;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@Priority(value=2000)
public class RolesAllowedFilter
implements ContainerRequestFilter {
    private final Set<String> allowedRoles;
    private final boolean allRolesAllowed;

    public RolesAllowedFilter(String[] allowedRoles) {
        this.allowedRoles = new HashSet<String>(Arrays.asList(allowedRoles));
        this.allRolesAllowed = this.allowedRoles.stream().anyMatch("*"::equals);
    }

    public void filter(ContainerRequestContext requestContext) {
        SecurityContext securityContext = requestContext.getSecurityContext();
        boolean isForbidden = this.allRolesAllowed ? securityContext.getUserPrincipal() == null : this.allowedRoles.stream().noneMatch(arg_0 -> ((SecurityContext)securityContext).isUserInRole(arg_0));
        if (isForbidden) {
            if (requestContext.getSecurityContext().getUserPrincipal() == null) {
                throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
            }
            throw new ForbiddenException();
        }
    }
}

