/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import io.smallrye.faulttolerance.metrics.MetricsCollector;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

@Singleton
public class StrategyCache {
    private final Map<InterceptionPoint, FaultToleranceStrategy<?>> strategies = new ConcurrentHashMap();
    private final Map<InterceptionPoint, MetricsCollector> metricsCollectors = new ConcurrentHashMap<InterceptionPoint, MetricsCollector>();

    public <V> FaultToleranceStrategy<V> getStrategy(InterceptionPoint point, Function<InterceptionPoint, FaultToleranceStrategy<V>> producer) {
        return this.strategies.computeIfAbsent(point, producer);
    }

    public MetricsCollector getMetrics(InterceptionPoint point, Function<InterceptionPoint, MetricsCollector> producer) {
        return this.metricsCollectors.computeIfAbsent(point, producer);
    }
}

