/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.as.ejb3.component.InvokeMethodOnTargetInterceptor;
import org.jboss.as.ejb3.component.interceptors.CurrentInvocationContextInterceptor;
import org.jboss.as.ejb3.component.session.SessionBeanComponentCreateService;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulRemoveInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulSessionSynchronizationInterceptor;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.ejb.client.SessionID;
import org.jboss.invocation.ContextClassLoaderInterceptor;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.InjectedValue;

public class StatefulSessionComponentCreateService
extends SessionBeanComponentCreateService {
    private final InterceptorFactory afterBegin;
    private final Method afterBeginMethod;
    private final InterceptorFactory afterCompletion;
    private final Method afterCompletionMethod;
    private final InterceptorFactory beforeCompletion;
    private final Method beforeCompletionMethod;
    private final InterceptorFactory prePassivate;
    private final InterceptorFactory postActivate;
    private final InjectedValue<DefaultAccessTimeoutService> defaultAccessTimeoutService = new InjectedValue();
    private final InjectedValue<AtomicLong> defaultStatefulSessionTimeoutValue = new InjectedValue();
    private final InterceptorFactory ejb2XRemoveMethod;
    private final Supplier<CacheFactory<SessionID, StatefulSessionComponentInstance>> cacheFactory;
    private final Set<Object> serializableInterceptorContextKeys;
    private final StatefulComponentDescription componentDescription;
    final boolean passivationCapable;

    public StatefulSessionComponentCreateService(ComponentConfiguration componentConfiguration, ApplicationExceptions ejbJarConfiguration, Supplier<CacheFactory<SessionID, StatefulSessionComponentInstance>> cacheFactory) {
        super(componentConfiguration, ejbJarConfiguration);
        StatefulComponentDescription componentDescription = (StatefulComponentDescription)componentConfiguration.getComponentDescription();
        ClassLoader classLoader = componentConfiguration.getModuleClassLoader();
        ImmediateInterceptorFactory tcclInterceptorFactory = new ImmediateInterceptorFactory((Interceptor)new ContextClassLoaderInterceptor(classLoader));
        InterceptorFactory namespaceContextInterceptorFactory = componentConfiguration.getNamespaceContextInterceptorFactory();
        this.afterBeginMethod = componentDescription.getAfterBegin();
        this.afterBegin = this.afterBeginMethod != null ? Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(this.afterBeginMethod)}) : null;
        this.afterCompletionMethod = componentDescription.getAfterCompletion();
        this.afterCompletion = this.afterCompletionMethod != null ? Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(this.afterCompletionMethod)}) : null;
        this.beforeCompletionMethod = componentDescription.getBeforeCompletion();
        this.beforeCompletion = this.beforeCompletionMethod != null ? Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{tcclInterceptorFactory, namespaceContextInterceptorFactory, CurrentInvocationContextInterceptor.FACTORY, StatefulSessionComponentCreateService.invokeMethodOnTarget(this.beforeCompletionMethod)}) : null;
        this.prePassivate = Interceptors.getChainedInterceptorFactory((Collection)componentConfiguration.getPrePassivateInterceptors());
        this.postActivate = Interceptors.getChainedInterceptorFactory((Collection)componentConfiguration.getPostActivateInterceptors());
        this.ejb2XRemoveMethod = Interceptors.getChainedInterceptorFactory((InterceptorFactory[])new InterceptorFactory[]{StatefulSessionSynchronizationInterceptor.factory(componentDescription.getTransactionManagementType()), new ImmediateInterceptorFactory((Interceptor)new StatefulRemoveInterceptor(false)), Interceptors.getTerminalInterceptorFactory()});
        this.serializableInterceptorContextKeys = componentConfiguration.getInterceptorContextKeys();
        this.passivationCapable = componentDescription.isPassivationApplicable();
        this.cacheFactory = cacheFactory;
        this.componentDescription = componentDescription;
    }

    private static InterceptorFactory invokeMethodOnTarget(Method method) {
        method.setAccessible(true);
        return InvokeMethodOnTargetInterceptor.factory(method);
    }

    protected BasicComponent createComponent() {
        return new StatefulSessionComponent(this);
    }

    public InterceptorFactory getAfterBegin() {
        return this.afterBegin;
    }

    public InterceptorFactory getAfterCompletion() {
        return this.afterCompletion;
    }

    public InterceptorFactory getBeforeCompletion() {
        return this.beforeCompletion;
    }

    public InterceptorFactory getPrePassivate() {
        return this.prePassivate;
    }

    public InterceptorFactory getPostActivate() {
        return this.postActivate;
    }

    public Method getAfterBeginMethod() {
        return this.afterBeginMethod;
    }

    public Method getAfterCompletionMethod() {
        return this.afterCompletionMethod;
    }

    public Method getBeforeCompletionMethod() {
        return this.beforeCompletionMethod;
    }

    public DefaultAccessTimeoutService getDefaultAccessTimeoutService() {
        return (DefaultAccessTimeoutService)this.defaultAccessTimeoutService.getValue();
    }

    Injector<DefaultAccessTimeoutService> getDefaultAccessTimeoutInjector() {
        return this.defaultAccessTimeoutService;
    }

    Injector<AtomicLong> getDefaultStatefulSessionTimeoutInjector() {
        return this.defaultStatefulSessionTimeoutValue;
    }

    void setDefaultStatefulSessionTimeout() {
        long timeoutVal;
        if (this.componentDescription.getStatefulTimeout() == null && (timeoutVal = ((AtomicLong)this.defaultStatefulSessionTimeoutValue.getValue()).get()) >= 0L) {
            this.componentDescription.setStatefulTimeout(new StatefulTimeoutInfo(timeoutVal, TimeUnit.MILLISECONDS));
        }
    }

    public InterceptorFactory getEjb2XRemoveMethod() {
        return this.ejb2XRemoveMethod;
    }

    public Set<Object> getSerializableInterceptorContextKeys() {
        return this.serializableInterceptorContextKeys;
    }

    Supplier<CacheFactory<SessionID, StatefulSessionComponentInstance>> getCacheFactory() {
        return this.cacheFactory;
    }
}

