/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQLockAcquisitionTimeoutException;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreSlavePolicy;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.BackupRecoveryJournalLoader;
import org.apache.activemq.artemis.core.server.impl.BackupTopologyListener;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.jboss.logging.Logger;

public final class SharedStoreBackupActivation
extends Activation {
    private static final Logger logger = Logger.getLogger(SharedStoreBackupActivation.class);
    private final SharedStoreSlavePolicy sharedStoreSlavePolicy;
    private final ActiveMQServerImpl activeMQServer;
    private final Object failbackCheckerGuard = new Object();
    private boolean cancelFailBackChecker;
    private NodeManager.LockListener activeLockListener;
    private final IOCriticalErrorListener ioCriticalErrorListener;
    private final AtomicBoolean restarting = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedStoreBackupActivation(ActiveMQServerImpl server, SharedStoreSlavePolicy sharedStoreSlavePolicy, IOCriticalErrorListener ioCriticalErrorListener) {
        this.activeMQServer = server;
        this.sharedStoreSlavePolicy = sharedStoreSlavePolicy;
        this.ioCriticalErrorListener = ioCriticalErrorListener;
        Object object = this.failbackCheckerGuard;
        synchronized (object) {
            this.cancelFailBackChecker = false;
        }
    }

    @Override
    public void run() {
        try {
            boolean scalingDown;
            this.registerActiveLockListener(this.activeMQServer.getNodeManager());
            this.activeMQServer.getNodeManager().startBackup();
            ScaleDownPolicy scaleDownPolicy = this.sharedStoreSlavePolicy.getScaleDownPolicy();
            boolean bl = scalingDown = scaleDownPolicy != null && scaleDownPolicy.isEnabled();
            if (!this.activeMQServer.initialisePart1(scalingDown)) {
                return;
            }
            this.activeMQServer.getBackupManager().start();
            this.activeMQServer.setState(ActiveMQServer.SERVER_STATE.STARTED);
            ActiveMQServerLogger.LOGGER.backupServerStarted(this.activeMQServer.getVersion().getFullVersion(), this.activeMQServer.getNodeManager().getNodeId());
            this.activeMQServer.getNodeManager().awaitLiveNode();
            this.sharedStoreSlavePolicy.getSharedStoreMasterPolicy().setSharedStoreSlavePolicy(this.sharedStoreSlavePolicy);
            this.activeMQServer.setHAPolicy(this.sharedStoreSlavePolicy.getSharedStoreMasterPolicy());
            this.activeMQServer.getBackupManager().activated();
            if (this.activeMQServer.getState() != ActiveMQServer.SERVER_STATE.STARTED) {
                return;
            }
            this.activeMQServer.initialisePart2(scalingDown);
            this.activeMQServer.completeActivation(false);
            if (scalingDown) {
                if (!this.restarting.compareAndSet(false, true)) {
                    return;
                }
                this.unregisterActiveLockListener(this.activeMQServer.getNodeManager());
                ActiveMQServerLogger.LOGGER.backupServerScaledDown();
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SharedStoreBackupActivation.this.activeMQServer.stop();
                            if (SharedStoreBackupActivation.this.sharedStoreSlavePolicy.isRestartBackup()) {
                                SharedStoreBackupActivation.this.activeMQServer.start();
                            }
                        }
                        catch (Exception e) {
                            ActiveMQServerLogger.LOGGER.serverRestartWarning(e);
                        }
                    }
                });
                t.start();
                return;
            }
            ActiveMQServerLogger.LOGGER.backupServerIsLive();
            this.activeMQServer.getNodeManager().releaseBackup();
            if (this.sharedStoreSlavePolicy.isAllowAutoFailBack() && ActiveMQServer.SERVER_STATE.STOPPING != this.activeMQServer.getState() && ActiveMQServer.SERVER_STATE.STOPPED != this.activeMQServer.getState()) {
                this.startFailbackChecker();
            }
        }
        catch (NodeManager.NodeManagerException nodeManagerException) {
            if (nodeManagerException.getCause() instanceof ClosedChannelException) {
                return;
            }
            if (nodeManagerException.getCause() instanceof ActiveMQLockAcquisitionTimeoutException) {
                ActiveMQServerLogger.LOGGER.initializationError(nodeManagerException.getCause());
                return;
            }
            this.unregisterActiveLockListener(this.activeMQServer.getNodeManager());
            this.ioCriticalErrorListener.onIOException((Throwable)nodeManagerException, nodeManagerException.getMessage(), null);
        }
        catch (InterruptedException | ClosedChannelException nodeManagerException) {
        }
        catch (Exception e) {
            if (!(e.getCause() instanceof InterruptedException)) {
                ActiveMQServerLogger.LOGGER.initializationError(e);
            }
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.initializationError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        if (!restarting) {
            Object object = this.failbackCheckerGuard;
            synchronized (object) {
                this.cancelFailBackChecker = true;
            }
        }
        NodeManager nodeManagerInUse = this.activeMQServer.getNodeManager();
        if (this.activeMQServer.getHAPolicy().isBackup()) {
            this.activeMQServer.interruptActivationThread(nodeManagerInUse);
            if (nodeManagerInUse != null) {
                this.unregisterActiveLockListener(nodeManagerInUse);
                nodeManagerInUse.stopBackup();
            }
        } else if (nodeManagerInUse != null) {
            this.unregisterActiveLockListener(nodeManagerInUse);
            if (this.sharedStoreSlavePolicy.isFailoverOnServerShutdown() || permanently) {
                try {
                    nodeManagerInUse.crashLiveServer();
                }
                catch (Throwable t) {
                    if (!permanently) {
                        throw t;
                    }
                    logger.warn((Object)"Errored while closing activation: can be ignored because of permanent close", t);
                }
            } else {
                nodeManagerInUse.pauseLiveServer();
            }
        }
    }

    private void registerActiveLockListener(NodeManager nodeManager) {
        NodeManager.LockListener lockListener;
        this.activeLockListener = lockListener = () -> {
            if (!this.restarting.compareAndSet(false, true)) {
                logger.warn((Object)"Restarting already happening on lost lock");
                return;
            }
            this.unregisterActiveLockListener(nodeManager);
            this.ioCriticalErrorListener.onIOException((Throwable)new IOException("lost lock"), "Lost NodeManager lock", null);
        };
        nodeManager.registerLockListener(lockListener);
    }

    private void unregisterActiveLockListener(NodeManager nodeManager) {
        NodeManager.LockListener activeLockListener = this.activeLockListener;
        if (activeLockListener != null) {
            nodeManager.unregisterLockListener(activeLockListener);
            this.activeLockListener = null;
        }
    }

    @Override
    public JournalLoader createJournalLoader(PostOffice postOffice, PagingManager pagingManager, StorageManager storageManager, QueueFactory queueFactory, NodeManager nodeManager, ManagementService managementService, GroupingHandler groupingHandler, Configuration configuration, ActiveMQServer parentServer) throws ActiveMQException {
        if (this.sharedStoreSlavePolicy.getScaleDownPolicy() != null && this.sharedStoreSlavePolicy.getScaleDownPolicy().isEnabled()) {
            return new BackupRecoveryJournalLoader(postOffice, pagingManager, storageManager, queueFactory, nodeManager, managementService, groupingHandler, configuration, parentServer, ScaleDownPolicy.getScaleDownConnector(this.sharedStoreSlavePolicy.getScaleDownPolicy(), this.activeMQServer), this.activeMQServer.getClusterManager().getClusterController());
        }
        return super.createJournalLoader(postOffice, pagingManager, storageManager, queueFactory, nodeManager, managementService, groupingHandler, configuration, parentServer);
    }

    private void startFailbackChecker() {
        this.activeMQServer.getScheduledPool().scheduleAtFixedRate(new FailbackChecker(), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private class FailbackChecker
    implements Runnable {
        BackupTopologyListener backupListener;

        FailbackChecker() {
            TransportConfiguration connector = SharedStoreBackupActivation.this.activeMQServer.getClusterManager().getDefaultConnection(null).getConnector();
            this.backupListener = new BackupTopologyListener(SharedStoreBackupActivation.this.activeMQServer.getNodeID().toString(), connector);
            SharedStoreBackupActivation.this.activeMQServer.getClusterManager().getDefaultConnection(null).addClusterTopologyListener(this.backupListener);
        }

        @Override
        public void run() {
            try {
                if (!SharedStoreBackupActivation.this.restarting.get() && SharedStoreBackupActivation.this.activeMQServer.getNodeManager().isAwaitingFailback() && this.backupListener.waitForBackup()) {
                    if (!SharedStoreBackupActivation.this.restarting.compareAndSet(false, true)) {
                        return;
                    }
                    ActiveMQServerLogger.LOGGER.awaitFailBack();
                    Thread t = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                logger.debug((Object)(SharedStoreBackupActivation.this.activeMQServer + "::Stopping live node in favor of failback"));
                                NodeManager nodeManager = SharedStoreBackupActivation.this.activeMQServer.getNodeManager();
                                SharedStoreBackupActivation.this.activeMQServer.stop(true, false, true);
                                nodeManager.start();
                                try {
                                    nodeManager.awaitLiveStatus();
                                }
                                finally {
                                    nodeManager.stop();
                                }
                                Object object = SharedStoreBackupActivation.this.failbackCheckerGuard;
                                synchronized (object) {
                                    if (SharedStoreBackupActivation.this.cancelFailBackChecker || !SharedStoreBackupActivation.this.sharedStoreSlavePolicy.isRestartBackup()) {
                                        return;
                                    }
                                    SharedStoreBackupActivation.this.activeMQServer.setHAPolicy(SharedStoreBackupActivation.this.sharedStoreSlavePolicy);
                                    logger.debug((Object)(SharedStoreBackupActivation.this.activeMQServer + "::Starting backup node now after failback"));
                                    SharedStoreBackupActivation.this.activeMQServer.start();
                                    NodeManager.LockListener lockListener = SharedStoreBackupActivation.this.activeLockListener;
                                    if (lockListener != null) {
                                        SharedStoreBackupActivation.this.activeMQServer.getNodeManager().registerLockListener(lockListener);
                                    }
                                }
                            }
                            catch (Exception e) {
                                ActiveMQServerLogger.LOGGER.serverRestartWarning(e);
                            }
                        }
                    });
                    t.start();
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.serverRestartWarning(e);
            }
        }
    }
}

