/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.generator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.util.Collections;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchMessages;
import org.jboss.as.patching.ZipUtils;
import org.jboss.as.patching.generator.Distribution;
import org.jboss.as.patching.generator.PatchBuilderWrapper;
import org.jboss.as.patching.generator.PatchConfig;
import org.jboss.as.patching.generator.PatchConfigXml;
import org.jboss.as.patching.generator.PatchContentWriter;
import org.jboss.as.patching.generator.TemplateGenerator;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.version.ProductConfig;
import org.jboss.as.version.Usage;
import org.jboss.modules.Module;
import org.wildfly.security.manager.ReadPropertyAction;

public class PatchGenerator {
    private final File patchConfigFile;
    private File oldRoot;
    private File newRoot;
    private File patchFile;
    private File tmp;

    public static void main(String[] args) {
        try {
            PatchGenerator patchGenerator = PatchGenerator.parse(args);
            if (patchGenerator != null) {
                patchGenerator.process();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PatchGenerator(File patchConfig, File oldRoot, File newRoot, File patchFile) {
        this.patchConfigFile = patchConfig;
        this.oldRoot = oldRoot;
        this.newRoot = newRoot;
        this.patchFile = patchFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws IOException, XMLStreamException {
        try {
            PatchConfig patchConfig = this.parsePatchConfig();
            TreeSet<String> required = new TreeSet<String>();
            if (this.newRoot == null) {
                required.add("--updated-dist");
            }
            if (this.oldRoot == null) {
                required.add("--applies-to-dist");
            }
            if (this.patchFile == null) {
                if (this.newRoot != null) {
                    this.patchFile = new File(this.newRoot, "patch-" + System.currentTimeMillis() + ".par");
                } else {
                    required.add("--output-file");
                }
            }
            if (!required.isEmpty()) {
                System.err.printf(PatchMessages.MESSAGES.missingRequiredArgs(required), new Object[0]);
                PatchGenerator.usage();
                return;
            }
            this.createTempStructure(patchConfig.getPatchId());
            Distribution base = Distribution.create(this.oldRoot);
            Distribution updated = Distribution.create(this.newRoot);
            if (!base.getName().equals(updated.getName())) {
                throw PatchGenerator.processingError("distribution names don't match, expected: %s, but was %s ", base.getName(), updated.getName());
            }
            if (patchConfig.getAppliesToProduct() != null && !patchConfig.getAppliesToProduct().equals(base.getName())) {
                throw PatchGenerator.processingError("patch target does not match, expected: %s, but was %s", patchConfig.getAppliesToProduct(), base.getName());
            }
            if (patchConfig.getAppliesToVersion() != null && !patchConfig.getAppliesToVersion().equals(base.getVersion())) {
                throw PatchGenerator.processingError("patch target version does not match, expected: %s, but was %s", patchConfig.getAppliesToVersion(), base.getVersion());
            }
            PatchBuilderWrapper builder = patchConfig.toPatchBuilder();
            builder.setPatchId(patchConfig.getPatchId());
            builder.setDescription(patchConfig.getDescription());
            if (patchConfig.getPatchType() == Patch.PatchType.CUMULATIVE) {
                if (base.getVersion().equals(updated.getVersion())) {
                    throw PatchGenerator.processingError("cumulative patch does not upgrade version %s", base.getVersion());
                }
                builder.upgradeIdentity(base.getName(), base.getVersion(), updated.getVersion());
            } else {
                builder.oneOffPatchIdentity(base.getName(), base.getVersion());
            }
            Patch patch = builder.compare(base, updated);
            PatchContentWriter.process(this.tmp, this.newRoot, patch);
            ZipUtils.zip(this.tmp, this.patchFile);
        }
        finally {
            IoUtils.recursiveDelete(this.tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PatchConfig parsePatchConfig() throws FileNotFoundException, XMLStreamException {
        PatchConfig patchConfig;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.patchConfigFile);
            BufferedInputStream bis = new BufferedInputStream(fis);
            patchConfig = PatchConfigXml.parse(bis);
        }
        catch (Throwable throwable) {
            IoUtils.safeClose(fis);
            throw throwable;
        }
        IoUtils.safeClose(fis);
        return patchConfig;
    }

    private void createTempStructure(String patchId) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        int count = 0;
        while (this.tmp == null || this.tmp.exists()) {
            this.tmp = new File(tmpDir, "jboss-as-patch-" + patchId + "-" + ++count);
        }
        if (!this.tmp.mkdirs()) {
            throw PatchGenerator.processingError("Cannot create tmp dir for patch create at %s", this.tmp.getAbsolutePath());
        }
        this.tmp.deleteOnExit();
        File metaInf = new File(this.tmp, "META-INF");
        metaInf.mkdir();
        metaInf.deleteOnExit();
        File misc = new File(this.tmp, "misc");
        misc.mkdir();
        misc.deleteOnExit();
    }

    private static PatchGenerator parse(String[] args) throws IOException {
        File patchConfig = null;
        File oldFile = null;
        File newFile = null;
        File patchFile = null;
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                String val;
                if ("--version".equals(arg) || "-v".equals(arg) || "-version".equals(arg) || "-V".equals(arg)) {
                    String homeDir = System.getSecurityManager() == null ? System.getProperty("jboss.home.dir") : (String)AccessController.doPrivileged(new ReadPropertyAction("jboss.home.dir"));
                    ProductConfig productConfig = new ProductConfig(Module.getBootModuleLoader(), homeDir, Collections.emptyMap());
                    System.out.println(productConfig.getPrettyVersionString());
                    return null;
                }
                if ("--help".equals(arg) || "-h".equals(arg) || "-H".equals(arg)) {
                    PatchGenerator.usage();
                    return null;
                }
                if (arg.startsWith("--applies-to-dist=")) {
                    val = arg.substring("--applies-to-dist=".length());
                    oldFile = new File(val);
                    if (!oldFile.exists()) {
                        System.err.printf(PatchMessages.MESSAGES.fileDoesNotExist(arg), new Object[0]);
                        PatchGenerator.usage();
                        return null;
                    }
                    if (oldFile.isDirectory()) continue;
                    System.err.printf(PatchMessages.MESSAGES.fileIsNotADirectory(arg), new Object[0]);
                    PatchGenerator.usage();
                    return null;
                }
                if (arg.startsWith("--updated-dist=")) {
                    val = arg.substring("--updated-dist=".length());
                    newFile = new File(val);
                    if (!newFile.exists()) {
                        System.err.printf(PatchMessages.MESSAGES.fileDoesNotExist(arg), new Object[0]);
                        PatchGenerator.usage();
                        return null;
                    }
                    if (newFile.isDirectory()) continue;
                    System.err.printf(PatchMessages.MESSAGES.fileIsNotADirectory(arg), new Object[0]);
                    PatchGenerator.usage();
                    return null;
                }
                if (arg.startsWith("--patch-config=")) {
                    val = arg.substring("--patch-config=".length());
                    patchConfig = new File(val);
                    if (!patchConfig.exists()) {
                        System.err.printf(PatchMessages.MESSAGES.fileDoesNotExist(arg), new Object[0]);
                        PatchGenerator.usage();
                        return null;
                    }
                    if (!patchConfig.isDirectory()) continue;
                    System.err.printf(PatchMessages.MESSAGES.fileIsADirectory(arg), new Object[0]);
                    PatchGenerator.usage();
                    return null;
                }
                if (arg.startsWith("--output-file=")) {
                    val = arg.substring("--output-file=".length());
                    patchFile = new File(val);
                    if (!patchFile.exists() || !patchFile.isDirectory()) continue;
                    System.err.printf(PatchMessages.MESSAGES.fileIsADirectory(arg), new Object[0]);
                    PatchGenerator.usage();
                    return null;
                }
                if (!arg.equals("--create-template")) continue;
                TemplateGenerator.generate(args);
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.printf(PatchMessages.MESSAGES.argumentExpected(arg), new Object[0]);
                PatchGenerator.usage();
                return null;
            }
        }
        if (patchConfig == null) {
            System.err.printf(PatchMessages.MESSAGES.missingRequiredArgs(Collections.singleton("--patch-config")), new Object[0]);
            PatchGenerator.usage();
            return null;
        }
        return new PatchGenerator(patchConfig, oldFile, newFile, patchFile);
    }

    private static void usage() {
        Usage usage = new Usage();
        usage.addArguments(new String[]{"--applies-to-dist=<file>"});
        usage.addInstruction(PatchMessages.MESSAGES.argAppliesToDist());
        usage.addArguments(new String[]{"-h", "--help"});
        usage.addInstruction(PatchMessages.MESSAGES.argHelp());
        usage.addArguments(new String[]{"--output-file=<file>"});
        usage.addInstruction(PatchMessages.MESSAGES.argOutputFile());
        usage.addArguments(new String[]{"--patch-config=<file>"});
        usage.addInstruction(PatchMessages.MESSAGES.argPatchConfig());
        usage.addArguments(new String[]{"--updated-dist=<file>"});
        usage.addInstruction(PatchMessages.MESSAGES.argUpdatedDist());
        usage.addArguments(new String[]{"-v", "--version"});
        usage.addInstruction(PatchMessages.MESSAGES.argVersion());
        String headline = usage.getDefaultUsageHeadline("patch-gen");
        System.out.print(usage.usage(headline));
    }

    static RuntimeException processingError(String message, Object ... arguments) {
        return new RuntimeException(String.format(message, arguments));
    }

    static RuntimeException processingError(Exception e, String message, Object ... arguments) {
        return new RuntimeException(String.format(message, arguments), e);
    }
}

