/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.cli;

import java.io.File;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.patching.PatchMessages;
import org.jboss.as.patching.cli.CandidatesProviders;
import org.jboss.as.patching.tool.PatchOperationBuilder;
import org.jboss.as.patching.tool.PatchOperationTarget;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.manager.ReadEnvironmentPropertyAction;
import org.wildfly.security.manager.ReadPropertyAction;

public class PatchHandler
extends CommandHandlerWithHelp {
    static final String PATCH = "patch";
    static final String APPLY = "apply";
    static final String ROLLBACK = "rollback";
    static final String HISTORY = "history";
    static final String INFO = "info";
    private final ArgumentWithValue host;
    private final ArgumentWithValue action = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new SimpleTabCompleter(new String[]{"apply", "rollback", "info", "history"}), 0, "--action");
    private final ArgumentWithoutValue path;
    private final ArgumentWithValue patchId;
    private final ArgumentWithoutValue rollbackTo;
    private final ArgumentWithValue resetConfiguration;
    private final ArgumentWithoutValue overrideModules;
    private final ArgumentWithoutValue overrideAll;
    private final ArgumentWithValue override;
    private final ArgumentWithValue preserve;
    private final ArgumentWithoutValue distribution;
    private static final String HOME = "JBOSS_HOME";
    private static final String HOME_DIR = "jboss.home.dir";

    public PatchHandler(CommandContext context) {
        super(PATCH, false);
        this.host = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new DefaultCompleter(CandidatesProviders.HOSTS), "--host"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                boolean connected = ctx.getControllerHost() != null;
                return connected && ctx.isDomainMode() && super.canAppearNext(ctx);
            }
        };
        this.overrideModules = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--override-modules"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.overrideModules.addRequiredPreceding((CommandArgument)this.action);
        this.overrideAll = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--override-all"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.overrideAll.addRequiredPreceding((CommandArgument)this.action);
        this.override = new ArgumentWithValue((CommandHandlerWithArguments)this, "--override"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.override.addRequiredPreceding((CommandArgument)this.action);
        this.preserve = new ArgumentWithValue((CommandHandlerWithArguments)this, "--preserve"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY, PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.preserve.addRequiredPreceding((CommandArgument)this.action);
        WindowsFilenameTabCompleter pathCompleter = Util.isWindows() ? new WindowsFilenameTabCompleter(context) : new DefaultFilenameTabCompleter(context);
        this.path = new FileSystemPathArgument((CommandHandlerWithArguments)this, (FilenameTabCompleter)pathCompleter, 1, "--path"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.APPLY})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.path.addRequiredPreceding((CommandArgument)this.action);
        this.patchId = new ArgumentWithValue((CommandHandlerWithArguments)this, "--patch-id"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.patchId.addRequiredPreceding((CommandArgument)this.action);
        this.rollbackTo = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--rollback-to"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.rollbackTo.addRequiredPreceding((CommandArgument)this.action);
        this.resetConfiguration = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)SimpleTabCompleter.BOOLEAN, "--reset-configuration"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (PatchHandler.this.canOnlyAppearAfterActions(ctx, new String[]{PatchHandler.ROLLBACK})) {
                    return super.canAppearNext(ctx);
                }
                return false;
            }
        };
        this.resetConfiguration.addRequiredPreceding((CommandArgument)this.action);
        this.distribution = new FileSystemPathArgument((CommandHandlerWithArguments)this, (FilenameTabCompleter)pathCompleter, "--distribution"){

            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                return false;
            }
        };
    }

    private boolean canOnlyAppearAfterActions(CommandContext ctx, String ... actions) {
        String actionStr = this.action.getValue(ctx.getParsedCommandLine());
        if (actionStr == null || actions.length == 0) {
            return false;
        }
        return Arrays.asList(actions).contains(actionStr);
    }

    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ModelNode result;
        PatchOperationTarget target = this.createPatchOperationTarget(ctx);
        PatchOperationBuilder builder = this.createPatchOperationBuilder(ctx.getParsedCommandLine());
        try {
            result = builder.execute(target);
        }
        catch (Exception e) {
            throw new CommandLineException("Unable to apply patch", (Throwable)e);
        }
        if (!Util.isSuccess((ModelNode)result)) {
            ModelNode fd = result.get("failure-description");
            if (!fd.isDefined()) {
                throw new CommandLineException("Failed to apply patch: " + result.asString());
            }
            if (fd.has("conflicts")) {
                StringBuilder buf = new StringBuilder();
                buf.append(fd.get("message").asString()).append(": ");
                ModelNode conflicts = fd.get("conflicts");
                String title = "";
                if (conflicts.has("bundles")) {
                    this.formatConflictsList(buf, conflicts, "", "bundles");
                    title = ", ";
                }
                if (conflicts.has("modules")) {
                    this.formatConflictsList(buf, conflicts, title, "modules");
                    title = ", ";
                }
                if (conflicts.has("misc")) {
                    this.formatConflictsList(buf, conflicts, title, "misc");
                }
                throw new CommandLineException(buf.toString());
            }
            throw new CommandLineException(Util.getFailureDescription((ModelNode)result));
        }
        ctx.printLine(result.toJSONString(false));
    }

    protected void formatConflictsList(StringBuilder buf, ModelNode conflicts, String title, String contentType) {
        buf.append(title);
        List list = conflicts.get(contentType).asList();
        int i = 0;
        while (i < list.size()) {
            ModelNode item = (ModelNode)list.get(i++);
            buf.append(item.asString());
            if (i >= list.size()) continue;
            buf.append(", ");
        }
    }

    private PatchOperationBuilder createPatchOperationBuilder(ParsedCommandLine args) throws CommandFormatException {
        String overrideList;
        PatchOperationBuilder builder;
        String action = this.action.getValue(args, true);
        if (APPLY.equals(action)) {
            String path = this.path.getValue(args, true);
            File f = new File(path);
            if (!f.exists()) {
                throw new CommandFormatException("Path " + f.getAbsolutePath() + " doesn't exist.");
            }
            if (f.isDirectory()) {
                throw new CommandFormatException(f.getAbsolutePath() + " is a directory.");
            }
            builder = PatchOperationBuilder.Factory.patch(f);
        } else if (ROLLBACK.equals(action)) {
            boolean resetConfig;
            String resetConfigValue = this.resetConfiguration.getValue(args, true);
            if ("true".equalsIgnoreCase(resetConfigValue)) {
                resetConfig = true;
            } else if ("false".equalsIgnoreCase(resetConfigValue)) {
                resetConfig = false;
            } else {
                throw new CommandFormatException("Unexpected value for --reset-configuration (only true and false are allowed): " + resetConfigValue);
            }
            if (this.patchId.isPresent(args)) {
                String id = this.patchId.getValue(args, true);
                boolean rollbackTo = this.rollbackTo.isPresent(args);
                builder = PatchOperationBuilder.Factory.rollback(id, rollbackTo, resetConfig);
            } else {
                builder = PatchOperationBuilder.Factory.rollbackLast(resetConfig);
            }
        } else {
            if (INFO.equals(action)) {
                PatchOperationBuilder builder2 = PatchOperationBuilder.Factory.info();
                return builder2;
            }
            if (HISTORY.equals(action)) {
                PatchOperationBuilder builder3 = PatchOperationBuilder.Factory.history();
                return builder3;
            }
            throw new CommandFormatException("Unrecognized action '" + action + "'");
        }
        if (this.overrideModules.isPresent(args)) {
            builder.ignoreModuleChanges();
        }
        if (this.overrideAll.isPresent(args)) {
            builder.overrideAll();
        }
        if (this.override.isPresent(args)) {
            overrideList = this.override.getValue(args);
            for (String path : overrideList.split(",+")) {
                builder.overrideItem(path);
            }
        }
        if (this.preserve.isPresent(args)) {
            overrideList = this.preserve.getValue(args);
            for (String path : overrideList.split(",+")) {
                builder.preserveItem(path);
            }
        }
        return builder;
    }

    private PatchOperationTarget createPatchOperationTarget(CommandContext ctx) throws CommandLineException {
        PatchOperationTarget target;
        boolean connected;
        boolean bl = connected = ctx.getControllerHost() != null;
        if (connected) {
            if (ctx.isDomainMode()) {
                String hostName = this.host.getValue(ctx.getParsedCommandLine(), true);
                target = PatchOperationTarget.createHost(hostName, ctx.getModelControllerClient());
            } else {
                target = PatchOperationTarget.createStandalone(ctx.getModelControllerClient());
            }
        } else {
            String jbossHome = this.getJBossHome(ctx.getParsedCommandLine());
            try {
                File root = new File(jbossHome);
                File modules = new File(root, "modules");
                File bundles = new File(root, "bundles");
                target = PatchOperationTarget.createLocal(root, Collections.singletonList(modules), Collections.singletonList(bundles));
            }
            catch (Exception e) {
                throw new CommandLineException("Unable to apply patch to local JBOSS_HOME=" + jbossHome, (Throwable)e);
            }
        }
        return target;
    }

    private String getJBossHome(ParsedCommandLine args) {
        String resolved;
        String targetDistro = this.distribution.getValue(args);
        if (targetDistro != null) {
            return targetDistro;
        }
        String string = resolved = System.getSecurityManager() == null ? System.getenv(HOME) : (String)AccessController.doPrivileged(new ReadEnvironmentPropertyAction(HOME));
        if (resolved == null) {
            String string2 = resolved = System.getSecurityManager() == null ? System.getProperty(HOME_DIR) : (String)AccessController.doPrivileged(new ReadPropertyAction(HOME_DIR));
        }
        if (resolved == null) {
            throw PatchMessages.MESSAGES.cliFailedToResolveDistribution();
        }
        File home = new File(resolved);
        File modules = new File(home, "modules");
        if (!modules.isDirectory()) {
            throw PatchMessages.MESSAGES.cliFailedToResolveDistribution();
        }
        return resolved;
    }
}

