/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry;

import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYOTELEXT", length=4)
interface OpenTelemetryExtensionLogger
extends BasicLogger {
    public static final OpenTelemetryExtensionLogger OTEL_LOGGER = (OpenTelemetryExtensionLogger)Logger.getMessageLogger(OpenTelemetryExtensionLogger.class, (String)OpenTelemetryExtensionLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Activating OpenTelemetry Subsystem")
    public void activatingSubsystem();

    @Message(id=4, value="Deployment %s requires use of the '%s' capability but it is not currently registered")
    public DeploymentUnitProcessingException deploymentRequiresCapability(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="Error resolving the OpenTelemetry instance.")
    public void errorResolvingTelemetry(@Cause Exception var1);

    @Message(id=8, value="An unsupported exporter was specified: '%s'.")
    public IllegalArgumentException unsupportedExporter(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=9, value="Error resolving the tracer.")
    public void errorResolvingTracer(@Cause Exception var1);

    @Message(id=10, value="An unsupported span processor was specified: '%s'.")
    public IllegalArgumentException unsupportedSpanProcessor(String var1);

    @Message(id=11, value="Unrecognized value for sampler: '%s'.")
    public IllegalArgumentException unsupportedSampler(String var1);

    @Message(id=12, value="Invalid ratio. Must be between 0.0 and 1.0 inclusive")
    public IllegalArgumentException invalidRatio();

    @Message(id=13, value="The 'jaeger' exporter is no longer supported. Please update the system to use otlp.")
    public String jaegerIsNoLongerSupported();
}

