/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.context;

import javax.naming.RefAddr;
import javax.naming.Reference;
import org.jboss.modules.Module;

public class ModularReference
extends Reference {
    private static final long serialVersionUID = -4805781394834948096L;
    private final String moduleName;

    public static ModularReference create(Class<?> type, Class<?> factoryClass) {
        return ModularReference.create(type.getName(), factoryClass);
    }

    public static ModularReference create(String className, Class<?> factoryClass) {
        return new ModularReference(className, factoryClass.getName(), Module.forClass(factoryClass).getName());
    }

    public static ModularReference create(Class<?> type, RefAddr addr, Class<?> factoryClass) {
        return ModularReference.create(type.getName(), addr, factoryClass);
    }

    public static ModularReference create(String className, RefAddr addr, Class<?> factoryClass) {
        return new ModularReference(className, addr, factoryClass.getName(), Module.forClass(factoryClass).getName());
    }

    private ModularReference(String className, String factory, String moduleName) {
        super(className, factory, null);
        this.moduleName = moduleName;
    }

    private ModularReference(String className, RefAddr addr, String factory, String moduleName) {
        super(className, addr, factory, null);
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }
}

