/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.util.MessageTracker;
import org.wildfly.naming.client.MarshallingCompatibilityHelper;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.remote.AggregateObjectResolver;
import org.wildfly.naming.client.remote.ProtocolUtils;
import org.wildfly.naming.client.remote.RemoteServerTransport;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class RemoteNamingService {
    private static final int[] SUPPORTED_PROTOCOL_VERSIONS = new int[]{1, 2};
    private final Context localContext;
    private Registration registration;

    public RemoteNamingService(Context localContext) {
        this.localContext = localContext;
    }

    public void start(Endpoint endpoint) throws IOException {
        this.registration = endpoint.registerService("naming", (OpenListener)new ChannelOpenListener(), OptionMap.EMPTY);
    }

    public void stop() throws IOException {
        this.registration.close();
    }

    public Context getLocalContext() {
        return this.localContext;
    }

    private class ChannelOpenListener
    implements OpenListener {
        private ChannelOpenListener() {
        }

        public void channelOpened(Channel channel) {
            final MessageTracker messageTracker = new MessageTracker(channel, ((Integer)channel.getOption(RemotingOptions.MAX_OUTBOUND_MESSAGES)).intValue());
            try {
                channel.receiveMessage(new Channel.Receiver(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleMessage(Channel channel, MessageInputStream message) {
                        try (MessageInputStream mis = message;){
                            byte[] namingHeader = new byte[6];
                            mis.read(namingHeader);
                            if (!Arrays.equals(namingHeader, ProtocolUtils.NAMING_BYTES)) {
                                throw Messages.log.invalidHeader();
                            }
                            int version = mis.readUnsignedByte();
                            boolean versionSupported = false;
                            for (int supportedProtocolVersion : SUPPORTED_PROTOCOL_VERSIONS) {
                                if (version != supportedProtocolVersion) continue;
                                versionSupported = true;
                                break;
                            }
                            if (!versionSupported) {
                                throw Messages.log.unsupportedProtocolVersion(version);
                            }
                            Context localContext = null;
                            RemoteNamingService remoteNamingService = RemoteNamingService.this;
                            synchronized (remoteNamingService) {
                                try {
                                    localContext = (Context)RemoteNamingService.this.getLocalContext().lookup("");
                                }
                                catch (NamingException e) {
                                    Messages.log.unexpectedError(e);
                                }
                            }
                            RemoteServerTransport remoteServerTransport = new RemoteServerTransport(channel, version, messageTracker, localContext);
                            List<MarshallingCompatibilityHelper> helpers = ProtocolUtils.getMarshallingCompatibilityHelpers();
                            ObjectResolver resolver = null;
                            for (MarshallingCompatibilityHelper helper : helpers) {
                                ObjectResolver nextResolver = helper.getObjectResolver(remoteServerTransport, false);
                                if (resolver == null) {
                                    resolver = nextResolver;
                                    continue;
                                }
                                if (resolver instanceof AggregateObjectResolver) {
                                    ((AggregateObjectResolver)resolver).add(nextResolver);
                                    continue;
                                }
                                resolver = new AggregateObjectResolver().add(nextResolver);
                            }
                            if (resolver != null) {
                                remoteServerTransport.getConfiguration().setObjectResolver(resolver);
                            }
                            remoteServerTransport.start();
                        }
                        catch (IOException | CommunicationException e) {
                            Messages.log.failedToDetermineClientVersion(e);
                        }
                    }

                    public void handleError(Channel channel, IOException error) {
                        try {
                            channel.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    public void handleEnd(Channel channel) {
                        try {
                            channel.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                try (MessageOutputStream mos = messageTracker.openMessage();){
                    mos.write(ProtocolUtils.NAMING_BYTES);
                    mos.writeByte(SUPPORTED_PROTOCOL_VERSIONS.length);
                    for (int version : SUPPORTED_PROTOCOL_VERSIONS) {
                        mos.writeByte(version > 1 ? version | 0x80 : version);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    IoUtils.safeClose((Closeable)channel);
                }
            }
            catch (IOException e) {
                Messages.log.failedToSendHeader(e);
                IoUtils.safeClose((Closeable)channel);
            }
        }

        public void registrationTerminated() {
        }
    }
}

